/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.model.EphemerisItem;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse;

public class ListEphemeridesIterable
implements SdkIterable<ListEphemeridesResponse> {
    private final GroundStationClient client;
    private final ListEphemeridesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEphemeridesIterable(GroundStationClient client, ListEphemeridesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEphemeridesResponseFetcher();
    }

    public Iterator<ListEphemeridesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EphemerisItem> ephemerides() {
        Function<ListEphemeridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ephemerides() != null) {
                return response.ephemerides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEphemeridesResponseFetcher
    implements SyncPageFetcher<ListEphemeridesResponse> {
        private ListEphemeridesResponseFetcher() {
        }

        public boolean hasNextPage(ListEphemeridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEphemeridesResponse nextPage(ListEphemeridesResponse previousPage) {
            if (previousPage == null) {
                return ListEphemeridesIterable.this.client.listEphemerides(ListEphemeridesIterable.this.firstRequest);
            }
            return ListEphemeridesIterable.this.client.listEphemerides((ListEphemeridesRequest)((Object)ListEphemeridesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

