/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.CapabilityArnListCopier;
import software.amazon.awssdk.services.groundstation.model.IpAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoveryData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiscoveryData> {
    private static final SdkField<List<String>> CAPABILITY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilityArns").getter(DiscoveryData.getter(DiscoveryData::capabilityArns)).setter(DiscoveryData.setter(Builder::capabilityArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("privateIpAddresses").getter(DiscoveryData.getter(DiscoveryData::privateIpAddresses)).setter(DiscoveryData.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PUBLIC_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("publicIpAddresses").getter(DiscoveryData.getter(DiscoveryData::publicIpAddresses)).setter(DiscoveryData.setter(Builder::publicIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITY_ARNS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, PUBLIC_IP_ADDRESSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> capabilityArns;
    private final List<String> privateIpAddresses;
    private final List<String> publicIpAddresses;

    private DiscoveryData(BuilderImpl builder) {
        this.capabilityArns = builder.capabilityArns;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.publicIpAddresses = builder.publicIpAddresses;
    }

    public final boolean hasCapabilityArns() {
        return this.capabilityArns != null && !(this.capabilityArns instanceof SdkAutoConstructList);
    }

    public final List<String> capabilityArns() {
        return this.capabilityArns;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final boolean hasPublicIpAddresses() {
        return this.publicIpAddresses != null && !(this.publicIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilityArns() ? this.capabilityArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicIpAddresses() ? this.publicIpAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveryData)) {
            return false;
        }
        DiscoveryData other = (DiscoveryData)obj;
        return this.hasCapabilityArns() == other.hasCapabilityArns() && Objects.equals(this.capabilityArns(), other.capabilityArns()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && this.hasPublicIpAddresses() == other.hasPublicIpAddresses() && Objects.equals(this.publicIpAddresses(), other.publicIpAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoveryData").add("CapabilityArns", this.hasCapabilityArns() ? this.capabilityArns() : null).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("PublicIpAddresses", this.hasPublicIpAddresses() ? this.publicIpAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capabilityArns": {
                return Optional.ofNullable(clazz.cast(this.capabilityArns()));
            }
            case "privateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "publicIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoveryData, T> g) {
        return obj -> g.apply((DiscoveryData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> capabilityArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> publicIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveryData model) {
            this.capabilityArns(model.capabilityArns);
            this.privateIpAddresses(model.privateIpAddresses);
            this.publicIpAddresses(model.publicIpAddresses);
        }

        public final Collection<String> getCapabilityArns() {
            if (this.capabilityArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilityArns;
        }

        public final void setCapabilityArns(Collection<String> capabilityArns) {
            this.capabilityArns = CapabilityArnListCopier.copy(capabilityArns);
        }

        @Override
        public final Builder capabilityArns(Collection<String> capabilityArns) {
            this.capabilityArns = CapabilityArnListCopier.copy(capabilityArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilityArns(String ... capabilityArns) {
            this.capabilityArns(Arrays.asList(capabilityArns));
            return this;
        }

        public final Collection<String> getPrivateIpAddresses() {
            if (this.privateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.privateIpAddresses;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpAddressListCopier.copy(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = IpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final Collection<String> getPublicIpAddresses() {
            if (this.publicIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicIpAddresses;
        }

        public final void setPublicIpAddresses(Collection<String> publicIpAddresses) {
            this.publicIpAddresses = IpAddressListCopier.copy(publicIpAddresses);
        }

        @Override
        public final Builder publicIpAddresses(Collection<String> publicIpAddresses) {
            this.publicIpAddresses = IpAddressListCopier.copy(publicIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpAddresses(String ... publicIpAddresses) {
            this.publicIpAddresses(Arrays.asList(publicIpAddresses));
            return this;
        }

        public DiscoveryData build() {
            return new DiscoveryData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiscoveryData> {
        public Builder capabilityArns(Collection<String> var1);

        public Builder capabilityArns(String ... var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder publicIpAddresses(Collection<String> var1);

        public Builder publicIpAddresses(String ... var1);
    }
}

