/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.model.GroundStationData;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsRequest;
import software.amazon.awssdk.services.groundstation.model.ListGroundStationsResponse;

public class ListGroundStationsIterable
implements SdkIterable<ListGroundStationsResponse> {
    private final GroundStationClient client;
    private final ListGroundStationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroundStationsIterable(GroundStationClient client, ListGroundStationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroundStationsResponseFetcher();
    }

    public Iterator<ListGroundStationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroundStationData> groundStationList() {
        Function<ListGroundStationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groundStationList() != null) {
                return response.groundStationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroundStationsResponseFetcher
    implements SyncPageFetcher<ListGroundStationsResponse> {
        private ListGroundStationsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroundStationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroundStationsResponse nextPage(ListGroundStationsResponse previousPage) {
            if (previousPage == null) {
                return ListGroundStationsIterable.this.client.listGroundStations(ListGroundStationsIterable.this.firstRequest);
            }
            return ListGroundStationsIterable.this.client.listGroundStations((ListGroundStationsRequest)((Object)ListGroundStationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

