/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that determines whether tracking should be used during a contact executed with this <code>Config</code> in the
 * mission profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingConfig implements SdkPojo, Serializable, ToCopyableBuilder<TrackingConfig.Builder, TrackingConfig> {
    private static final SdkField<String> AUTOTRACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autotrack").getter(getter(TrackingConfig::autotrackAsString)).setter(setter(Builder::autotrack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autotrack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOTRACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autotrack;

    private TrackingConfig(BuilderImpl builder) {
        this.autotrack = builder.autotrack;
    }

    /**
     * <p>
     * Current setting for autotrack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autotrack} will
     * return {@link Criticality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autotrackAsString}.
     * </p>
     * 
     * @return Current setting for autotrack.
     * @see Criticality
     */
    public final Criticality autotrack() {
        return Criticality.fromValue(autotrack);
    }

    /**
     * <p>
     * Current setting for autotrack.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autotrack} will
     * return {@link Criticality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autotrackAsString}.
     * </p>
     * 
     * @return Current setting for autotrack.
     * @see Criticality
     */
    public final String autotrackAsString() {
        return autotrack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autotrackAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingConfig)) {
            return false;
        }
        TrackingConfig other = (TrackingConfig) obj;
        return Objects.equals(autotrackAsString(), other.autotrackAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackingConfig").add("Autotrack", autotrackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autotrack":
            return Optional.ofNullable(clazz.cast(autotrackAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrackingConfig, T> g) {
        return obj -> g.apply((TrackingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackingConfig> {
        /**
         * <p>
         * Current setting for autotrack.
         * </p>
         * 
         * @param autotrack
         *        Current setting for autotrack.
         * @see Criticality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Criticality
         */
        Builder autotrack(String autotrack);

        /**
         * <p>
         * Current setting for autotrack.
         * </p>
         * 
         * @param autotrack
         *        Current setting for autotrack.
         * @see Criticality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Criticality
         */
        Builder autotrack(Criticality autotrack);
    }

    static final class BuilderImpl implements Builder {
        private String autotrack;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingConfig model) {
            autotrack(model.autotrack);
        }

        public final String getAutotrack() {
            return autotrack;
        }

        @Override
        public final Builder autotrack(String autotrack) {
            this.autotrack = autotrack;
            return this;
        }

        @Override
        public final Builder autotrack(Criticality autotrack) {
            this.autotrack(autotrack == null ? null : autotrack.toString());
            return this;
        }

        public final void setAutotrack(String autotrack) {
            this.autotrack = autotrack;
        }

        @Override
        public TrackingConfig build() {
            return new TrackingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
