/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMissionProfileResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetMissionProfileResponse.Builder, GetMissionProfileResponse> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPostPassDurationSeconds")
            .getter(getter(GetMissionProfileResponse::contactPostPassDurationSeconds))
            .setter(setter(Builder::contactPostPassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPrePassDurationSeconds")
            .getter(getter(GetMissionProfileResponse::contactPrePassDurationSeconds))
            .setter(setter(Builder::contactPrePassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds")
                    .build()).build();

    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("dataflowEdges")
            .getter(getter(GetMissionProfileResponse::dataflowEdges))
            .setter(setter(Builder::dataflowEdges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumViableContactDurationSeconds")
            .getter(getter(GetMissionProfileResponse::minimumViableContactDurationSeconds))
            .setter(setter(Builder::minimumViableContactDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("minimumViableContactDurationSeconds").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileArn").getter(getter(GetMissionProfileResponse::missionProfileArn))
            .setter(setter(Builder::missionProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("missionProfileId").getter(getter(GetMissionProfileResponse::missionProfileId))
            .setter(setter(Builder::missionProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetMissionProfileResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GetMissionProfileResponse::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetMissionProfileResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingConfigArn").getter(getter(GetMissionProfileResponse::trackingConfigArn))
            .setter(setter(Builder::trackingConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD,
            MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, MISSION_PROFILE_ARN_FIELD, MISSION_PROFILE_ID_FIELD, NAME_FIELD,
            REGION_FIELD, TAGS_FIELD, TRACKING_CONFIG_ARN_FIELD));

    private final Integer contactPostPassDurationSeconds;

    private final Integer contactPrePassDurationSeconds;

    private final List<List<String>> dataflowEdges;

    private final Integer minimumViableContactDurationSeconds;

    private final String missionProfileArn;

    private final String missionProfileId;

    private final String name;

    private final String region;

    private final Map<String, String> tags;

    private final String trackingConfigArn;

    private GetMissionProfileResponse(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.missionProfileArn = builder.missionProfileArn;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.region = builder.region;
        this.tags = builder.tags;
        this.trackingConfigArn = builder.trackingConfigArn;
    }

    /**
     * <p>
     * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     * finished.
     * </p>
     * 
     * @return Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     *         finished.
     */
    public final Integer contactPostPassDurationSeconds() {
        return contactPostPassDurationSeconds;
    }

    /**
     * <p>
     * Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.
     * </p>
     * 
     * @return Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming
     *         pass.
     */
    public final Integer contactPrePassDurationSeconds() {
        return contactPrePassDurationSeconds;
    }

    /**
     * Returns true if the DataflowEdges property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDataflowEdges() {
        return dataflowEdges != null && !(dataflowEdges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
     * <code>Config</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataflowEdges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
     *         <i>to</i> <code>Config</code>.
     */
    public final List<List<String>> dataflowEdges() {
        return dataflowEdges;
    }

    /**
     * <p>
     * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not
     * present you with contacts shorter than this duration.
     * </p>
     * 
     * @return Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
     *         will not present you with contacts shorter than this duration.
     */
    public final Integer minimumViableContactDurationSeconds() {
        return minimumViableContactDurationSeconds;
    }

    /**
     * <p>
     * ARN of a mission profile.
     * </p>
     * 
     * @return ARN of a mission profile.
     */
    public final String missionProfileArn() {
        return missionProfileArn;
    }

    /**
     * <p>
     * UUID of a mission profile.
     * </p>
     * 
     * @return UUID of a mission profile.
     */
    public final String missionProfileId() {
        return missionProfileId;
    }

    /**
     * <p>
     * Name of a mission profile.
     * </p>
     * 
     * @return Name of a mission profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Region of a mission profile.
     * </p>
     * 
     * @return Region of a mission profile.
     */
    public final String region() {
        return region;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a mission profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to a mission profile.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * ARN of a tracking <code>Config</code>.
     * </p>
     * 
     * @return ARN of a tracking <code>Config</code>.
     */
    public final String trackingConfigArn() {
        return trackingConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataflowEdges() ? dataflowEdges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trackingConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMissionProfileResponse)) {
            return false;
        }
        GetMissionProfileResponse other = (GetMissionProfileResponse) obj;
        return Objects.equals(contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds())
                && Objects.equals(contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds())
                && hasDataflowEdges() == other.hasDataflowEdges() && Objects.equals(dataflowEdges(), other.dataflowEdges())
                && Objects.equals(minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds())
                && Objects.equals(missionProfileArn(), other.missionProfileArn())
                && Objects.equals(missionProfileId(), other.missionProfileId()) && Objects.equals(name(), other.name())
                && Objects.equals(region(), other.region()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(trackingConfigArn(), other.trackingConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMissionProfileResponse")
                .add("ContactPostPassDurationSeconds", contactPostPassDurationSeconds())
                .add("ContactPrePassDurationSeconds", contactPrePassDurationSeconds())
                .add("DataflowEdges", hasDataflowEdges() ? dataflowEdges() : null)
                .add("MinimumViableContactDurationSeconds", minimumViableContactDurationSeconds())
                .add("MissionProfileArn", missionProfileArn()).add("MissionProfileId", missionProfileId()).add("Name", name())
                .add("Region", region()).add("Tags", hasTags() ? tags() : null).add("TrackingConfigArn", trackingConfigArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactPostPassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPostPassDurationSeconds()));
        case "contactPrePassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPrePassDurationSeconds()));
        case "dataflowEdges":
            return Optional.ofNullable(clazz.cast(dataflowEdges()));
        case "minimumViableContactDurationSeconds":
            return Optional.ofNullable(clazz.cast(minimumViableContactDurationSeconds()));
        case "missionProfileArn":
            return Optional.ofNullable(clazz.cast(missionProfileArn()));
        case "missionProfileId":
            return Optional.ofNullable(clazz.cast(missionProfileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "trackingConfigArn":
            return Optional.ofNullable(clazz.cast(trackingConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMissionProfileResponse, T> g) {
        return obj -> g.apply((GetMissionProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMissionProfileResponse> {
        /**
         * <p>
         * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
         * finished.
         * </p>
         * 
         * @param contactPostPassDurationSeconds
         *        Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass
         *        has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds);

        /**
         * <p>
         * Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming pass.
         * </p>
         * 
         * @param contactPrePassDurationSeconds
         *        Amount of time prior to contact start you’d like to receive a CloudWatch event indicating an upcoming
         *        pass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
         *        <i>to</i> <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
         *        <i>to</i> <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<String>... dataflowEdges);

        /**
         * <p>
         * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will
         * not present you with contacts shorter than this duration.
         * </p>
         * 
         * @param minimumViableContactDurationSeconds
         *        Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
         *        will not present you with contacts shorter than this duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds);

        /**
         * <p>
         * ARN of a mission profile.
         * </p>
         * 
         * @param missionProfileArn
         *        ARN of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileArn(String missionProfileArn);

        /**
         * <p>
         * UUID of a mission profile.
         * </p>
         * 
         * @param missionProfileId
         *        UUID of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileId(String missionProfileId);

        /**
         * <p>
         * Name of a mission profile.
         * </p>
         * 
         * @param name
         *        Name of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Region of a mission profile.
         * </p>
         * 
         * @param region
         *        Region of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Tags assigned to a mission profile.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * ARN of a tracking <code>Config</code>.
         * </p>
         * 
         * @param trackingConfigArn
         *        ARN of a tracking <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingConfigArn(String trackingConfigArn);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private Integer contactPostPassDurationSeconds;

        private Integer contactPrePassDurationSeconds;

        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumViableContactDurationSeconds;

        private String missionProfileArn;

        private String missionProfileId;

        private String name;

        private String region;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String trackingConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMissionProfileResponse model) {
            super(model);
            contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            dataflowEdges(model.dataflowEdges);
            minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            missionProfileArn(model.missionProfileArn);
            missionProfileId(model.missionProfileId);
            name(model.name);
            region(model.region);
            tags(model.tags);
            trackingConfigArn(model.trackingConfigArn);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            if (dataflowEdges instanceof SdkAutoConstructList) {
                return null;
            }
            return dataflowEdges;
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String>... dataflowEdges) {
            dataflowEdges(Arrays.asList(dataflowEdges));
            return this;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        public final String getMissionProfileArn() {
            return missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final String getMissionProfileId() {
            return missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getTrackingConfigArn() {
            return trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public GetMissionProfileResponse build() {
            return new GetMissionProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
