/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for certain <code>Config</code> object types in a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigDetails implements SdkPojo, Serializable, ToCopyableBuilder<ConfigDetails.Builder, ConfigDetails> {
    private static final SdkField<AntennaDemodDecodeDetails> ANTENNA_DEMOD_DECODE_DETAILS_FIELD = SdkField
            .<AntennaDemodDecodeDetails> builder(MarshallingType.SDK_POJO).memberName("antennaDemodDecodeDetails")
            .getter(getter(ConfigDetails::antennaDemodDecodeDetails)).setter(setter(Builder::antennaDemodDecodeDetails))
            .constructor(AntennaDemodDecodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDemodDecodeDetails").build())
            .build();

    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField
            .<EndpointDetails> builder(MarshallingType.SDK_POJO).memberName("endpointDetails")
            .getter(getter(ConfigDetails::endpointDetails)).setter(setter(Builder::endpointDetails))
            .constructor(EndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANTENNA_DEMOD_DECODE_DETAILS_FIELD, ENDPOINT_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AntennaDemodDecodeDetails antennaDemodDecodeDetails;

    private final EndpointDetails endpointDetails;

    private ConfigDetails(BuilderImpl builder) {
        this.antennaDemodDecodeDetails = builder.antennaDemodDecodeDetails;
        this.endpointDetails = builder.endpointDetails;
    }

    /**
     * <p>
     * Details for antenna demod decode <code>Config</code> in a contact.
     * </p>
     * 
     * @return Details for antenna demod decode <code>Config</code> in a contact.
     */
    public final AntennaDemodDecodeDetails antennaDemodDecodeDetails() {
        return antennaDemodDecodeDetails;
    }

    /**
     * Returns the value of the EndpointDetails property for this object.
     * 
     * @return The value of the EndpointDetails property for this object.
     */
    public final EndpointDetails endpointDetails() {
        return endpointDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(antennaDemodDecodeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpointDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigDetails)) {
            return false;
        }
        ConfigDetails other = (ConfigDetails) obj;
        return Objects.equals(antennaDemodDecodeDetails(), other.antennaDemodDecodeDetails())
                && Objects.equals(endpointDetails(), other.endpointDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigDetails").add("AntennaDemodDecodeDetails", antennaDemodDecodeDetails())
                .add("EndpointDetails", endpointDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "antennaDemodDecodeDetails":
            return Optional.ofNullable(clazz.cast(antennaDemodDecodeDetails()));
        case "endpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigDetails, T> g) {
        return obj -> g.apply((ConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigDetails> {
        /**
         * <p>
         * Details for antenna demod decode <code>Config</code> in a contact.
         * </p>
         * 
         * @param antennaDemodDecodeDetails
         *        Details for antenna demod decode <code>Config</code> in a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder antennaDemodDecodeDetails(AntennaDemodDecodeDetails antennaDemodDecodeDetails);

        /**
         * <p>
         * Details for antenna demod decode <code>Config</code> in a contact.
         * </p>
         * This is a convenience that creates an instance of the {@link AntennaDemodDecodeDetails.Builder} avoiding the
         * need to create one manually via {@link AntennaDemodDecodeDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AntennaDemodDecodeDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #antennaDemodDecodeDetails(AntennaDemodDecodeDetails)}.
         * 
         * @param antennaDemodDecodeDetails
         *        a consumer that will call methods on {@link AntennaDemodDecodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #antennaDemodDecodeDetails(AntennaDemodDecodeDetails)
         */
        default Builder antennaDemodDecodeDetails(Consumer<AntennaDemodDecodeDetails.Builder> antennaDemodDecodeDetails) {
            return antennaDemodDecodeDetails(AntennaDemodDecodeDetails.builder().applyMutation(antennaDemodDecodeDetails).build());
        }

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * @param endpointDetails
         *        The new value for the EndpointDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails endpointDetails);

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointDetails.Builder} avoiding the need to
         * create one manually via {@link EndpointDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointDetails(EndpointDetails)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on {@link EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(EndpointDetails)
         */
        default Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return endpointDetails(EndpointDetails.builder().applyMutation(endpointDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AntennaDemodDecodeDetails antennaDemodDecodeDetails;

        private EndpointDetails endpointDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigDetails model) {
            antennaDemodDecodeDetails(model.antennaDemodDecodeDetails);
            endpointDetails(model.endpointDetails);
        }

        public final AntennaDemodDecodeDetails.Builder getAntennaDemodDecodeDetails() {
            return antennaDemodDecodeDetails != null ? antennaDemodDecodeDetails.toBuilder() : null;
        }

        @Override
        public final Builder antennaDemodDecodeDetails(AntennaDemodDecodeDetails antennaDemodDecodeDetails) {
            this.antennaDemodDecodeDetails = antennaDemodDecodeDetails;
            return this;
        }

        public final void setAntennaDemodDecodeDetails(AntennaDemodDecodeDetails.BuilderImpl antennaDemodDecodeDetails) {
            this.antennaDemodDecodeDetails = antennaDemodDecodeDetails != null ? antennaDemodDecodeDetails.build() : null;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return endpointDetails != null ? endpointDetails.toBuilder() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        @Override
        public ConfigDetails build() {
            return new ConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
