/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReserveContactRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, ReserveContactRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReserveContactRequest.getter(ReserveContactRequest::endTime)).setter(ReserveContactRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReserveContactRequest.getter(ReserveContactRequest::groundStation)).setter(ReserveContactRequest.setter(Builder::groundStation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReserveContactRequest.getter(ReserveContactRequest::missionProfileArn)).setter(ReserveContactRequest.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReserveContactRequest.getter(ReserveContactRequest::satelliteArn)).setter(ReserveContactRequest.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReserveContactRequest.getter(ReserveContactRequest::startTime)).setter(ReserveContactRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ReserveContactRequest.getter(ReserveContactRequest::tags)).setter(ReserveContactRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, GROUND_STATION_FIELD, MISSION_PROFILE_ARN_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, TAGS_FIELD));
    private final Instant endTime;
    private final String groundStation;
    private final String missionProfileArn;
    private final String satelliteArn;
    private final Instant startTime;
    private final Map<String, String> tags;

    private ReserveContactRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.missionProfileArn = builder.missionProfileArn;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String groundStation() {
        return this.groundStation;
    }

    public String missionProfileArn() {
        return this.missionProfileArn;
    }

    public String satelliteArn() {
        return this.satelliteArn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReserveContactRequest)) {
            return false;
        }
        ReserveContactRequest other = (ReserveContactRequest)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.groundStation(), other.groundStation()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ReserveContactRequest").add("EndTime", (Object)this.endTime()).add("GroundStation", (Object)this.groundStation()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("SatelliteArn", (Object)this.satelliteArn()).add("StartTime", (Object)this.startTime()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "groundStation": {
                return Optional.ofNullable(clazz.cast(this.groundStation()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReserveContactRequest, T> g) {
        return obj -> g.apply((ReserveContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private Instant endTime;
        private String groundStation;
        private String missionProfileArn;
        private String satelliteArn;
        private Instant startTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReserveContactRequest model) {
            super(model);
            this.endTime(model.endTime);
            this.groundStation(model.groundStation);
            this.missionProfileArn(model.missionProfileArn);
            this.satelliteArn(model.satelliteArn);
            this.startTime(model.startTime);
            this.tags(model.tags);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getGroundStation() {
            return this.groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReserveContactRequest build() {
            return new ReserveContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReserveContactRequest> {
        public Builder endTime(Instant var1);

        public Builder groundStation(String var1);

        public Builder missionProfileArn(String var1);

        public Builder satelliteArn(String var1);

        public Builder startTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

