/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MissionProfileListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MissionProfileListItem> {
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MissionProfileListItem.getter(MissionProfileListItem::missionProfileArn)).setter(MissionProfileListItem.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MissionProfileListItem.getter(MissionProfileListItem::missionProfileId)).setter(MissionProfileListItem.setter(Builder::missionProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MissionProfileListItem.getter(MissionProfileListItem::name)).setter(MissionProfileListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MissionProfileListItem.getter(MissionProfileListItem::region)).setter(MissionProfileListItem.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_ARN_FIELD, MISSION_PROFILE_ID_FIELD, NAME_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String missionProfileArn;
    private final String missionProfileId;
    private final String name;
    private final String region;

    private MissionProfileListItem(BuilderImpl builder) {
        this.missionProfileArn = builder.missionProfileArn;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.region = builder.region;
    }

    public String missionProfileArn() {
        return this.missionProfileArn;
    }

    public String missionProfileId() {
        return this.missionProfileId;
    }

    public String name() {
        return this.name;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissionProfileListItem)) {
            return false;
        }
        MissionProfileListItem other = (MissionProfileListItem)obj;
        return Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.missionProfileId(), other.missionProfileId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"MissionProfileListItem").add("MissionProfileArn", (Object)this.missionProfileArn()).add("MissionProfileId", (Object)this.missionProfileId()).add("Name", (Object)this.name()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "missionProfileId": {
                return Optional.ofNullable(clazz.cast(this.missionProfileId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MissionProfileListItem, T> g) {
        return obj -> g.apply((MissionProfileListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String missionProfileArn;
        private String missionProfileId;
        private String name;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(MissionProfileListItem model) {
            this.missionProfileArn(model.missionProfileArn);
            this.missionProfileId(model.missionProfileId);
            this.name(model.name);
            this.region(model.region);
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final String getMissionProfileId() {
            return this.missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public MissionProfileListItem build() {
            return new MissionProfileListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MissionProfileListItem> {
        public Builder missionProfileArn(String var1);

        public Builder missionProfileId(String var1);

        public Builder name(String var1);

        public Builder region(String var1);
    }
}

