/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Item in a list of satellites.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SatelliteListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SatelliteListItem.Builder, SatelliteListItem> {
    private static final SdkField<List<String>> GROUND_STATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SatelliteListItem::groundStations))
            .setter(setter(Builder::groundStations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SatelliteListItem::noradSatelliteID)).setter(setter(Builder::noradSatelliteID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()).build();

    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SatelliteListItem::satelliteArn)).setter(setter(Builder::satelliteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()).build();

    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SatelliteListItem::satelliteId)).setter(setter(Builder::satelliteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_STATIONS_FIELD,
            NORAD_SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, SATELLITE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> groundStations;

    private final Integer noradSatelliteID;

    private final String satelliteArn;

    private final String satelliteId;

    private SatelliteListItem(BuilderImpl builder) {
        this.groundStations = builder.groundStations;
        this.noradSatelliteID = builder.noradSatelliteID;
        this.satelliteArn = builder.satelliteArn;
        this.satelliteId = builder.satelliteId;
    }

    /**
     * Returns true if the GroundStations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroundStations() {
        return groundStations != null && !(groundStations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ground stations to which the satellite is on-boarded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroundStations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of ground stations to which the satellite is on-boarded.
     */
    public List<String> groundStations() {
        return groundStations;
    }

    /**
     * <p>
     * NORAD satellite ID number.
     * </p>
     * 
     * @return NORAD satellite ID number.
     */
    public Integer noradSatelliteID() {
        return noradSatelliteID;
    }

    /**
     * <p>
     * ARN of a satellite.
     * </p>
     * 
     * @return ARN of a satellite.
     */
    public String satelliteArn() {
        return satelliteArn;
    }

    /**
     * <p>
     * UUID of a satellite.
     * </p>
     * 
     * @return UUID of a satellite.
     */
    public String satelliteId() {
        return satelliteId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groundStations());
        hashCode = 31 * hashCode + Objects.hashCode(noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SatelliteListItem)) {
            return false;
        }
        SatelliteListItem other = (SatelliteListItem) obj;
        return Objects.equals(groundStations(), other.groundStations())
                && Objects.equals(noradSatelliteID(), other.noradSatelliteID())
                && Objects.equals(satelliteArn(), other.satelliteArn()) && Objects.equals(satelliteId(), other.satelliteId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SatelliteListItem").add("GroundStations", groundStations())
                .add("NoradSatelliteID", noradSatelliteID()).add("SatelliteArn", satelliteArn())
                .add("SatelliteId", satelliteId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groundStations":
            return Optional.ofNullable(clazz.cast(groundStations()));
        case "noradSatelliteID":
            return Optional.ofNullable(clazz.cast(noradSatelliteID()));
        case "satelliteArn":
            return Optional.ofNullable(clazz.cast(satelliteArn()));
        case "satelliteId":
            return Optional.ofNullable(clazz.cast(satelliteId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SatelliteListItem, T> g) {
        return obj -> g.apply((SatelliteListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SatelliteListItem> {
        /**
         * <p>
         * A list of ground stations to which the satellite is on-boarded.
         * </p>
         * 
         * @param groundStations
         *        A list of ground stations to which the satellite is on-boarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStations(Collection<String> groundStations);

        /**
         * <p>
         * A list of ground stations to which the satellite is on-boarded.
         * </p>
         * 
         * @param groundStations
         *        A list of ground stations to which the satellite is on-boarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStations(String... groundStations);

        /**
         * <p>
         * NORAD satellite ID number.
         * </p>
         * 
         * @param noradSatelliteID
         *        NORAD satellite ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noradSatelliteID(Integer noradSatelliteID);

        /**
         * <p>
         * ARN of a satellite.
         * </p>
         * 
         * @param satelliteArn
         *        ARN of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteArn(String satelliteArn);

        /**
         * <p>
         * UUID of a satellite.
         * </p>
         * 
         * @param satelliteId
         *        UUID of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteId(String satelliteId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> groundStations = DefaultSdkAutoConstructList.getInstance();

        private Integer noradSatelliteID;

        private String satelliteArn;

        private String satelliteId;

        private BuilderImpl() {
        }

        private BuilderImpl(SatelliteListItem model) {
            groundStations(model.groundStations);
            noradSatelliteID(model.noradSatelliteID);
            satelliteArn(model.satelliteArn);
            satelliteId(model.satelliteId);
        }

        public final Collection<String> getGroundStations() {
            return groundStations;
        }

        @Override
        public final Builder groundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStations(String... groundStations) {
            groundStations(Arrays.asList(groundStations));
            return this;
        }

        public final void setGroundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
        }

        public final Integer getNoradSatelliteID() {
            return noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        public final String getSatelliteArn() {
            return satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final String getSatelliteId() {
            return satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public SatelliteListItem build() {
            return new SatelliteListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
