/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReserveContactRequest extends GroundStationRequest implements
        ToCopyableBuilder<ReserveContactRequest.Builder, ReserveContactRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReserveContactRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> GROUND_STATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReserveContactRequest::groundStation)).setter(setter(Builder::groundStation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStation").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReserveContactRequest::missionProfileArn)).setter(setter(Builder::missionProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()).build();

    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReserveContactRequest::satelliteArn)).setter(setter(Builder::satelliteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReserveContactRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ReserveContactRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            GROUND_STATION_FIELD, MISSION_PROFILE_ARN_FIELD, SATELLITE_ARN_FIELD, START_TIME_FIELD, TAGS_FIELD));

    private final Instant endTime;

    private final String groundStation;

    private final String missionProfileArn;

    private final String satelliteArn;

    private final Instant startTime;

    private final Map<String, String> tags;

    private ReserveContactRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.groundStation = builder.groundStation;
        this.missionProfileArn = builder.missionProfileArn;
        this.satelliteArn = builder.satelliteArn;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * End time of a contact.
     * </p>
     * 
     * @return End time of a contact.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Name of a ground station.
     * </p>
     * 
     * @return Name of a ground station.
     */
    public String groundStation() {
        return groundStation;
    }

    /**
     * <p>
     * ARN of a mission profile.
     * </p>
     * 
     * @return ARN of a mission profile.
     */
    public String missionProfileArn() {
        return missionProfileArn;
    }

    /**
     * <p>
     * ARN of a satellite
     * </p>
     * 
     * @return ARN of a satellite
     */
    public String satelliteArn() {
        return satelliteArn;
    }

    /**
     * <p>
     * Start time of a contact.
     * </p>
     * 
     * @return Start time of a contact.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to a contact.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(groundStation());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReserveContactRequest)) {
            return false;
        }
        ReserveContactRequest other = (ReserveContactRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(groundStation(), other.groundStation())
                && Objects.equals(missionProfileArn(), other.missionProfileArn())
                && Objects.equals(satelliteArn(), other.satelliteArn()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReserveContactRequest").add("EndTime", endTime()).add("GroundStation", groundStation())
                .add("MissionProfileArn", missionProfileArn()).add("SatelliteArn", satelliteArn()).add("StartTime", startTime())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "groundStation":
            return Optional.ofNullable(clazz.cast(groundStation()));
        case "missionProfileArn":
            return Optional.ofNullable(clazz.cast(missionProfileArn()));
        case "satelliteArn":
            return Optional.ofNullable(clazz.cast(satelliteArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReserveContactRequest, T> g) {
        return obj -> g.apply((ReserveContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ReserveContactRequest> {
        /**
         * <p>
         * End time of a contact.
         * </p>
         * 
         * @param endTime
         *        End time of a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Name of a ground station.
         * </p>
         * 
         * @param groundStation
         *        Name of a ground station.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundStation(String groundStation);

        /**
         * <p>
         * ARN of a mission profile.
         * </p>
         * 
         * @param missionProfileArn
         *        ARN of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileArn(String missionProfileArn);

        /**
         * <p>
         * ARN of a satellite
         * </p>
         * 
         * @param satelliteArn
         *        ARN of a satellite
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteArn(String satelliteArn);

        /**
         * <p>
         * Start time of a contact.
         * </p>
         * 
         * @param startTime
         *        Start time of a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Tags assigned to a contact.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private String groundStation;

        private String missionProfileArn;

        private String satelliteArn;

        private Instant startTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReserveContactRequest model) {
            super(model);
            endTime(model.endTime);
            groundStation(model.groundStation);
            missionProfileArn(model.missionProfileArn);
            satelliteArn(model.satelliteArn);
            startTime(model.startTime);
            tags(model.tags);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getGroundStation() {
            return groundStation;
        }

        @Override
        public final Builder groundStation(String groundStation) {
            this.groundStation = groundStation;
            return this;
        }

        public final void setGroundStation(String groundStation) {
            this.groundStation = groundStation;
        }

        public final String getMissionProfileArn() {
            return missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        public final String getSatelliteArn() {
            return satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReserveContactRequest build() {
            return new ReserveContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
