/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSatellitesResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListSatellitesResponse.Builder, ListSatellitesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSatellitesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SatelliteListItem>> SATELLITES_FIELD = SdkField
            .<List<SatelliteListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListSatellitesResponse::satellites))
            .setter(setter(Builder::satellites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satellites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SatelliteListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SatelliteListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SATELLITES_FIELD));

    private final String nextToken;

    private final List<SatelliteListItem> satellites;

    private ListSatellitesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.satellites = builder.satellites;
    }

    /**
     * <p>
     * Next token that can be supplied in the next call to get the next page of satellites.
     * </p>
     * 
     * @return Next token that can be supplied in the next call to get the next page of satellites.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Satellites property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSatellites() {
        return satellites != null && !(satellites instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of satellites.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSatellites()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of satellites.
     */
    public List<SatelliteListItem> satellites() {
        return satellites;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(satellites());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSatellitesResponse)) {
            return false;
        }
        ListSatellitesResponse other = (ListSatellitesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(satellites(), other.satellites());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSatellitesResponse").add("NextToken", nextToken()).add("Satellites", satellites()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "satellites":
            return Optional.ofNullable(clazz.cast(satellites()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSatellitesResponse, T> g) {
        return obj -> g.apply((ListSatellitesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSatellitesResponse> {
        /**
         * <p>
         * Next token that can be supplied in the next call to get the next page of satellites.
         * </p>
         * 
         * @param nextToken
         *        Next token that can be supplied in the next call to get the next page of satellites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of satellites.
         * </p>
         * 
         * @param satellites
         *        List of satellites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satellites(Collection<SatelliteListItem> satellites);

        /**
         * <p>
         * List of satellites.
         * </p>
         * 
         * @param satellites
         *        List of satellites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satellites(SatelliteListItem... satellites);

        /**
         * <p>
         * List of satellites.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SatelliteListItem>.Builder} avoiding the
         * need to create one manually via {@link List<SatelliteListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SatelliteListItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #satellites(List<SatelliteListItem>)}.
         * 
         * @param satellites
         *        a consumer that will call methods on {@link List<SatelliteListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #satellites(List<SatelliteListItem>)
         */
        Builder satellites(Consumer<SatelliteListItem.Builder>... satellites);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SatelliteListItem> satellites = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSatellitesResponse model) {
            super(model);
            nextToken(model.nextToken);
            satellites(model.satellites);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SatelliteListItem.Builder> getSatellites() {
            return satellites != null ? satellites.stream().map(SatelliteListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder satellites(Collection<SatelliteListItem> satellites) {
            this.satellites = SatelliteListCopier.copy(satellites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satellites(SatelliteListItem... satellites) {
            satellites(Arrays.asList(satellites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder satellites(Consumer<SatelliteListItem.Builder>... satellites) {
            satellites(Stream.of(satellites).map(c -> SatelliteListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSatellites(Collection<SatelliteListItem.BuilderImpl> satellites) {
            this.satellites = SatelliteListCopier.copyFromBuilder(satellites);
        }

        @Override
        public ListSatellitesResponse build() {
            return new ListSatellitesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
