/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigsResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListConfigsResponse.Builder, ListConfigsResponse> {
    private static final SdkField<List<ConfigListItem>> CONFIG_LIST_FIELD = SdkField
            .<List<ConfigListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListConfigsResponse::configList))
            .setter(setter(Builder::configList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ConfigListItem> configList;

    private final String nextToken;

    private ListConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.configList = builder.configList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ConfigList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConfigList() {
        return configList != null && !(configList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>Config</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfigList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of <code>Config</code> items.
     */
    public List<ConfigListItem> configList() {
        return configList;
    }

    /**
     * <p>
     * Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of
     * results.
     * </p>
     * 
     * @return Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next
     *         page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigsResponse)) {
            return false;
        }
        ListConfigsResponse other = (ListConfigsResponse) obj;
        return Objects.equals(configList(), other.configList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListConfigsResponse").add("ConfigList", configList()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configList":
            return Optional.ofNullable(clazz.cast(configList()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigsResponse, T> g) {
        return obj -> g.apply((ListConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConfigsResponse> {
        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * 
         * @param configList
         *        List of <code>Config</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configList(Collection<ConfigListItem> configList);

        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * 
         * @param configList
         *        List of <code>Config</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configList(ConfigListItem... configList);

        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConfigListItem>.Builder} avoiding the need
         * to create one manually via {@link List<ConfigListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #configList(List<ConfigListItem>)}.
         * 
         * @param configList
         *        a consumer that will call methods on {@link List<ConfigListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configList(List<ConfigListItem>)
         */
        Builder configList(Consumer<ConfigListItem.Builder>... configList);

        /**
         * <p>
         * Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private List<ConfigListItem> configList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigsResponse model) {
            super(model);
            configList(model.configList);
            nextToken(model.nextToken);
        }

        public final Collection<ConfigListItem.Builder> getConfigList() {
            return configList != null ? configList.stream().map(ConfigListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configList(Collection<ConfigListItem> configList) {
            this.configList = ConfigListCopier.copy(configList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(ConfigListItem... configList) {
            configList(Arrays.asList(configList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(Consumer<ConfigListItem.Builder>... configList) {
            configList(Stream.of(configList).map(c -> ConfigListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigList(Collection<ConfigListItem.BuilderImpl> configList) {
            this.configList = ConfigListCopier.copyFromBuilder(configList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigsResponse build() {
            return new ListConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
