/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that represents EIRP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eirp implements SdkPojo, Serializable, ToCopyableBuilder<Eirp.Builder, Eirp> {
    private static final SdkField<String> UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Eirp::unitsAsString)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Eirp::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNITS_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String units;

    private final Double value;

    private Eirp(BuilderImpl builder) {
        this.units = builder.units;
        this.value = builder.value;
    }

    /**
     * <p>
     * Units of an EIRP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link EirpUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Units of an EIRP.
     * @see EirpUnits
     */
    public EirpUnits units() {
        return EirpUnits.fromValue(units);
    }

    /**
     * <p>
     * Units of an EIRP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link EirpUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Units of an EIRP.
     * @see EirpUnits
     */
    public String unitsAsString() {
        return units;
    }

    /**
     * <p>
     * Value of an EIRP.
     * </p>
     * 
     * @return Value of an EIRP.
     */
    public Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eirp)) {
            return false;
        }
        Eirp other = (Eirp) obj;
        return Objects.equals(unitsAsString(), other.unitsAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Eirp").add("Units", unitsAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "units":
            return Optional.ofNullable(clazz.cast(unitsAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eirp, T> g) {
        return obj -> g.apply((Eirp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eirp> {
        /**
         * <p>
         * Units of an EIRP.
         * </p>
         * 
         * @param units
         *        Units of an EIRP.
         * @see EirpUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EirpUnits
         */
        Builder units(String units);

        /**
         * <p>
         * Units of an EIRP.
         * </p>
         * 
         * @param units
         *        Units of an EIRP.
         * @see EirpUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EirpUnits
         */
        Builder units(EirpUnits units);

        /**
         * <p>
         * Value of an EIRP.
         * </p>
         * 
         * @param value
         *        Value of an EIRP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String units;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(Eirp model) {
            units(model.units);
            value(model.value);
        }

        public final String getUnits() {
            return units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        public final Builder units(EirpUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        public final Double getValue() {
            return value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public Eirp build() {
            return new Eirp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
