/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the demodulation <code>Config</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DemodulationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DemodulationConfig.Builder, DemodulationConfig> {
    private static final SdkField<String> UNVALIDATED_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DemodulationConfig::unvalidatedJSON)).setter(setter(Builder::unvalidatedJSON))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unvalidatedJSON").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNVALIDATED_JSON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String unvalidatedJSON;

    private DemodulationConfig(BuilderImpl builder) {
        this.unvalidatedJSON = builder.unvalidatedJSON;
    }

    /**
     * <p>
     * Unvalidated JSON of a demodulation <code>Config</code>.
     * </p>
     * 
     * @return Unvalidated JSON of a demodulation <code>Config</code>.
     */
    public String unvalidatedJSON() {
        return unvalidatedJSON;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unvalidatedJSON());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DemodulationConfig)) {
            return false;
        }
        DemodulationConfig other = (DemodulationConfig) obj;
        return Objects.equals(unvalidatedJSON(), other.unvalidatedJSON());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DemodulationConfig").add("UnvalidatedJSON", unvalidatedJSON()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unvalidatedJSON":
            return Optional.ofNullable(clazz.cast(unvalidatedJSON()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DemodulationConfig, T> g) {
        return obj -> g.apply((DemodulationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DemodulationConfig> {
        /**
         * <p>
         * Unvalidated JSON of a demodulation <code>Config</code>.
         * </p>
         * 
         * @param unvalidatedJSON
         *        Unvalidated JSON of a demodulation <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unvalidatedJSON(String unvalidatedJSON);
    }

    static final class BuilderImpl implements Builder {
        private String unvalidatedJSON;

        private BuilderImpl() {
        }

        private BuilderImpl(DemodulationConfig model) {
            unvalidatedJSON(model.unvalidatedJSON);
        }

        public final String getUnvalidatedJSON() {
            return unvalidatedJSON;
        }

        @Override
        public final Builder unvalidatedJSON(String unvalidatedJSON) {
            this.unvalidatedJSON = unvalidatedJSON;
            return this;
        }

        public final void setUnvalidatedJSON(String unvalidatedJSON) {
            this.unvalidatedJSON = unvalidatedJSON;
        }

        @Override
        public DemodulationConfig build() {
            return new DemodulationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
