/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a dataflow endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataflowEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<DataflowEndpoint.Builder, DataflowEndpoint> {
    private static final SdkField<SocketAddress> ADDRESS_FIELD = SdkField.<SocketAddress> builder(MarshallingType.SDK_POJO)
            .getter(getter(DataflowEndpoint::address)).setter(setter(Builder::address)).constructor(SocketAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataflowEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DataflowEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, NAME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SocketAddress address;

    private final String name;

    private final String status;

    private DataflowEndpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * Socket address of a dataflow endpoint.
     * </p>
     * 
     * @return Socket address of a dataflow endpoint.
     */
    public SocketAddress address() {
        return address;
    }

    /**
     * <p>
     * Name of a dataflow endpoint.
     * </p>
     * 
     * @return Name of a dataflow endpoint.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Status of a dataflow endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of a dataflow endpoint.
     * @see EndpointStatus
     */
    public EndpointStatus status() {
        return EndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of a dataflow endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of a dataflow endpoint.
     * @see EndpointStatus
     */
    public String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpoint)) {
            return false;
        }
        DataflowEndpoint other = (DataflowEndpoint) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DataflowEndpoint").add("Address", address()).add("Name", name()).add("Status", statusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpoint, T> g) {
        return obj -> g.apply((DataflowEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataflowEndpoint> {
        /**
         * <p>
         * Socket address of a dataflow endpoint.
         * </p>
         * 
         * @param address
         *        Socket address of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(SocketAddress address);

        /**
         * <p>
         * Socket address of a dataflow endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link SocketAddress.Builder} avoiding the need to
         * create one manually via {@link SocketAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link SocketAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #address(SocketAddress)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link SocketAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(SocketAddress)
         */
        default Builder address(Consumer<SocketAddress.Builder> address) {
            return address(SocketAddress.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * Name of a dataflow endpoint.
         * </p>
         * 
         * @param name
         *        Name of a dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Status of a dataflow endpoint.
         * </p>
         * 
         * @param status
         *        Status of a dataflow endpoint.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of a dataflow endpoint.
         * </p>
         * 
         * @param status
         *        Status of a dataflow endpoint.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder status(EndpointStatus status);
    }

    static final class BuilderImpl implements Builder {
        private SocketAddress address;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpoint model) {
            address(model.address);
            name(model.name);
            status(model.status);
        }

        public final SocketAddress.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        @Override
        public final Builder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        public final void setAddress(SocketAddress.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DataflowEndpoint build() {
            return new DataflowEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
