/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMissionProfileRequest extends GroundStationRequest implements
        ToCopyableBuilder<UpdateMissionProfileRequest.Builder, UpdateMissionProfileRequest> {
    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMissionProfileRequest::contactPostPassDurationSeconds))
            .setter(setter(Builder::contactPostPassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMissionProfileRequest::contactPrePassDurationSeconds))
            .setter(setter(Builder::contactPrePassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds")
                    .build()).build();

    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .getter(getter(UpdateMissionProfileRequest::dataflowEdges))
            .setter(setter(Builder::dataflowEdges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMissionProfileRequest::minimumViableContactDurationSeconds))
            .setter(setter(Builder::minimumViableContactDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("minimumViableContactDurationSeconds").build()).build();

    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMissionProfileRequest::missionProfileId)).setter(setter(Builder::missionProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("missionProfileId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMissionProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMissionProfileRequest::trackingConfigArn)).setter(setter(Builder::trackingConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTACT_POST_PASS_DURATION_SECONDS_FIELD, CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD,
            MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, MISSION_PROFILE_ID_FIELD, NAME_FIELD, TRACKING_CONFIG_ARN_FIELD));

    private final Integer contactPostPassDurationSeconds;

    private final Integer contactPrePassDurationSeconds;

    private final List<List<String>> dataflowEdges;

    private final Integer minimumViableContactDurationSeconds;

    private final String missionProfileId;

    private final String name;

    private final String trackingConfigArn;

    private UpdateMissionProfileRequest(BuilderImpl builder) {
        super(builder);
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.missionProfileId = builder.missionProfileId;
        this.name = builder.name;
        this.trackingConfigArn = builder.trackingConfigArn;
    }

    /**
     * <p>
     * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     * finished.
     * </p>
     * 
     * @return Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     *         finished.
     */
    public Integer contactPostPassDurationSeconds() {
        return contactPostPassDurationSeconds;
    }

    /**
     * <p>
     * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     * finished.
     * </p>
     * 
     * @return Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
     *         finished.
     */
    public Integer contactPrePassDurationSeconds() {
        return contactPrePassDurationSeconds;
    }

    /**
     * Returns true if the DataflowEdges property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDataflowEdges() {
        return dataflowEdges != null && !(dataflowEdges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
     * <code>Config</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDataflowEdges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
     *         <code>Config</code>.
     */
    public List<List<String>> dataflowEdges() {
        return dataflowEdges;
    }

    /**
     * <p>
     * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not
     * present you with contacts shorter than this duration.
     * </p>
     * 
     * @return Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
     *         will not present you with contacts shorter than this duration.
     */
    public Integer minimumViableContactDurationSeconds() {
        return minimumViableContactDurationSeconds;
    }

    /**
     * <p>
     * ID of a mission profile.
     * </p>
     * 
     * @return ID of a mission profile.
     */
    public String missionProfileId() {
        return missionProfileId;
    }

    /**
     * <p>
     * Name of a mission profile.
     * </p>
     * 
     * @return Name of a mission profile.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * ARN of a tracking <code>Config</code>.
     * </p>
     * 
     * @return ARN of a tracking <code>Config</code>.
     */
    public String trackingConfigArn() {
        return trackingConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEdges());
        hashCode = 31 * hashCode + Objects.hashCode(minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trackingConfigArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMissionProfileRequest)) {
            return false;
        }
        UpdateMissionProfileRequest other = (UpdateMissionProfileRequest) obj;
        return Objects.equals(contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds())
                && Objects.equals(contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds())
                && Objects.equals(dataflowEdges(), other.dataflowEdges())
                && Objects.equals(minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds())
                && Objects.equals(missionProfileId(), other.missionProfileId()) && Objects.equals(name(), other.name())
                && Objects.equals(trackingConfigArn(), other.trackingConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateMissionProfileRequest")
                .add("ContactPostPassDurationSeconds", contactPostPassDurationSeconds())
                .add("ContactPrePassDurationSeconds", contactPrePassDurationSeconds()).add("DataflowEdges", dataflowEdges())
                .add("MinimumViableContactDurationSeconds", minimumViableContactDurationSeconds())
                .add("MissionProfileId", missionProfileId()).add("Name", name()).add("TrackingConfigArn", trackingConfigArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactPostPassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPostPassDurationSeconds()));
        case "contactPrePassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPrePassDurationSeconds()));
        case "dataflowEdges":
            return Optional.ofNullable(clazz.cast(dataflowEdges()));
        case "minimumViableContactDurationSeconds":
            return Optional.ofNullable(clazz.cast(minimumViableContactDurationSeconds()));
        case "missionProfileId":
            return Optional.ofNullable(clazz.cast(missionProfileId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trackingConfigArn":
            return Optional.ofNullable(clazz.cast(trackingConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMissionProfileRequest, T> g) {
        return obj -> g.apply((UpdateMissionProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMissionProfileRequest> {
        /**
         * <p>
         * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
         * finished.
         * </p>
         * 
         * @param contactPostPassDurationSeconds
         *        Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass
         *        has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds);

        /**
         * <p>
         * Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass has
         * finished.
         * </p>
         * 
         * @param contactPrePassDurationSeconds
         *        Amount of time after a contact ends that you’d like to receive a CloudWatch event indicating the pass
         *        has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
         *        <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a from <code>Config</code> and a to
         *        <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<String>... dataflowEdges);

        /**
         * <p>
         * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will
         * not present you with contacts shorter than this duration.
         * </p>
         * 
         * @param minimumViableContactDurationSeconds
         *        Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
         *        will not present you with contacts shorter than this duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds);

        /**
         * <p>
         * ID of a mission profile.
         * </p>
         * 
         * @param missionProfileId
         *        ID of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missionProfileId(String missionProfileId);

        /**
         * <p>
         * Name of a mission profile.
         * </p>
         * 
         * @param name
         *        Name of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ARN of a tracking <code>Config</code>.
         * </p>
         * 
         * @param trackingConfigArn
         *        ARN of a tracking <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingConfigArn(String trackingConfigArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private Integer contactPostPassDurationSeconds;

        private Integer contactPrePassDurationSeconds;

        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();

        private Integer minimumViableContactDurationSeconds;

        private String missionProfileId;

        private String name;

        private String trackingConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMissionProfileRequest model) {
            super(model);
            contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            dataflowEdges(model.dataflowEdges);
            minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            missionProfileId(model.missionProfileId);
            name(model.name);
            trackingConfigArn(model.trackingConfigArn);
        }

        public final Integer getContactPostPassDurationSeconds() {
            return contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            return dataflowEdges;
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String>... dataflowEdges) {
            dataflowEdges(Arrays.asList(dataflowEdges));
            return this;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        public final String getMissionProfileId() {
            return missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTrackingConfigArn() {
            return trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMissionProfileRequest build() {
            return new UpdateMissionProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
