/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSatelliteResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetSatelliteResponse.Builder, GetSatelliteResponse> {
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetSatelliteResponse::dateCreated)).setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetSatelliteResponse::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetSatelliteResponse::noradSatelliteID)).setter(setter(Builder::noradSatelliteID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()).build();

    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSatelliteResponse::satelliteArn)).setter(setter(Builder::satelliteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()).build();

    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSatelliteResponse::satelliteId)).setter(setter(Builder::satelliteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetSatelliteResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_CREATED_FIELD,
            LAST_UPDATED_FIELD, NORAD_SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, SATELLITE_ID_FIELD, TAGS_FIELD));

    private final Instant dateCreated;

    private final Instant lastUpdated;

    private final Integer noradSatelliteID;

    private final String satelliteArn;

    private final String satelliteId;

    private final Map<String, String> tags;

    private GetSatelliteResponse(BuilderImpl builder) {
        super(builder);
        this.dateCreated = builder.dateCreated;
        this.lastUpdated = builder.lastUpdated;
        this.noradSatelliteID = builder.noradSatelliteID;
        this.satelliteArn = builder.satelliteArn;
        this.satelliteId = builder.satelliteId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * When a satellite was created.
     * </p>
     * 
     * @return When a satellite was created.
     */
    public Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * When a satellite was last updated.
     * </p>
     * 
     * @return When a satellite was last updated.
     */
    public Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * NORAD satellite ID number.
     * </p>
     * 
     * @return NORAD satellite ID number.
     */
    public Integer noradSatelliteID() {
        return noradSatelliteID;
    }

    /**
     * <p>
     * ARN of a satellite.
     * </p>
     * 
     * @return ARN of a satellite.
     */
    public String satelliteArn() {
        return satelliteArn;
    }

    /**
     * <p>
     * UUID of a satellite.
     * </p>
     * 
     * @return UUID of a satellite.
     */
    public String satelliteId() {
        return satelliteId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a satellite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to a satellite.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSatelliteResponse)) {
            return false;
        }
        GetSatelliteResponse other = (GetSatelliteResponse) obj;
        return Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(noradSatelliteID(), other.noradSatelliteID())
                && Objects.equals(satelliteArn(), other.satelliteArn()) && Objects.equals(satelliteId(), other.satelliteId())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSatelliteResponse").add("DateCreated", dateCreated()).add("LastUpdated", lastUpdated())
                .add("NoradSatelliteID", noradSatelliteID()).add("SatelliteArn", satelliteArn())
                .add("SatelliteId", satelliteId()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "noradSatelliteID":
            return Optional.ofNullable(clazz.cast(noradSatelliteID()));
        case "satelliteArn":
            return Optional.ofNullable(clazz.cast(satelliteArn()));
        case "satelliteId":
            return Optional.ofNullable(clazz.cast(satelliteId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSatelliteResponse, T> g) {
        return obj -> g.apply((GetSatelliteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSatelliteResponse> {
        /**
         * <p>
         * When a satellite was created.
         * </p>
         * 
         * @param dateCreated
         *        When a satellite was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * When a satellite was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        When a satellite was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * NORAD satellite ID number.
         * </p>
         * 
         * @param noradSatelliteID
         *        NORAD satellite ID number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noradSatelliteID(Integer noradSatelliteID);

        /**
         * <p>
         * ARN of a satellite.
         * </p>
         * 
         * @param satelliteArn
         *        ARN of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteArn(String satelliteArn);

        /**
         * <p>
         * UUID of a satellite.
         * </p>
         * 
         * @param satelliteId
         *        UUID of a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteId(String satelliteId);

        /**
         * <p>
         * Tags assigned to a satellite.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a satellite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private Instant dateCreated;

        private Instant lastUpdated;

        private Integer noradSatelliteID;

        private String satelliteArn;

        private String satelliteId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSatelliteResponse model) {
            super(model);
            dateCreated(model.dateCreated);
            lastUpdated(model.lastUpdated);
            noradSatelliteID(model.noradSatelliteID);
            satelliteArn(model.satelliteArn);
            satelliteId(model.satelliteId);
            tags(model.tags);
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Integer getNoradSatelliteID() {
            return noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        public final String getSatelliteArn() {
            return satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        public final String getSatelliteId() {
            return satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetSatelliteResponse build() {
            return new GetSatelliteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
