/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the rollout configuration for a job. This configuration defines the rate at which the job
 * deploys a configuration to a fleet of target devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IoTJobExecutionsRolloutConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IoTJobExecutionsRolloutConfig.Builder, IoTJobExecutionsRolloutConfig> {
    private static final SdkField<IoTJobExponentialRolloutRate> EXPONENTIAL_RATE_FIELD = SdkField
            .<IoTJobExponentialRolloutRate> builder(MarshallingType.SDK_POJO).memberName("exponentialRate")
            .getter(getter(IoTJobExecutionsRolloutConfig::exponentialRate)).setter(setter(Builder::exponentialRate))
            .constructor(IoTJobExponentialRolloutRate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exponentialRate").build()).build();

    private static final SdkField<Integer> MAXIMUM_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumPerMinute").getter(getter(IoTJobExecutionsRolloutConfig::maximumPerMinute))
            .setter(setter(Builder::maximumPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumPerMinute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPONENTIAL_RATE_FIELD,
            MAXIMUM_PER_MINUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IoTJobExponentialRolloutRate exponentialRate;

    private final Integer maximumPerMinute;

    private IoTJobExecutionsRolloutConfig(BuilderImpl builder) {
        this.exponentialRate = builder.exponentialRate;
        this.maximumPerMinute = builder.maximumPerMinute;
    }

    /**
     * <p>
     * The exponential rate to increase the job rollout rate.
     * </p>
     * 
     * @return The exponential rate to increase the job rollout rate.
     */
    public final IoTJobExponentialRolloutRate exponentialRate() {
        return exponentialRate;
    }

    /**
     * <p>
     * The maximum number of devices that receive a pending job notification, per minute.
     * </p>
     * 
     * @return The maximum number of devices that receive a pending job notification, per minute.
     */
    public final Integer maximumPerMinute() {
        return maximumPerMinute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exponentialRate());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPerMinute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobExecutionsRolloutConfig)) {
            return false;
        }
        IoTJobExecutionsRolloutConfig other = (IoTJobExecutionsRolloutConfig) obj;
        return Objects.equals(exponentialRate(), other.exponentialRate())
                && Objects.equals(maximumPerMinute(), other.maximumPerMinute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IoTJobExecutionsRolloutConfig").add("ExponentialRate", exponentialRate())
                .add("MaximumPerMinute", maximumPerMinute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exponentialRate":
            return Optional.ofNullable(clazz.cast(exponentialRate()));
        case "maximumPerMinute":
            return Optional.ofNullable(clazz.cast(maximumPerMinute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exponentialRate", EXPONENTIAL_RATE_FIELD);
        map.put("maximumPerMinute", MAXIMUM_PER_MINUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IoTJobExecutionsRolloutConfig, T> g) {
        return obj -> g.apply((IoTJobExecutionsRolloutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IoTJobExecutionsRolloutConfig> {
        /**
         * <p>
         * The exponential rate to increase the job rollout rate.
         * </p>
         * 
         * @param exponentialRate
         *        The exponential rate to increase the job rollout rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exponentialRate(IoTJobExponentialRolloutRate exponentialRate);

        /**
         * <p>
         * The exponential rate to increase the job rollout rate.
         * </p>
         * This is a convenience method that creates an instance of the {@link IoTJobExponentialRolloutRate.Builder}
         * avoiding the need to create one manually via {@link IoTJobExponentialRolloutRate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IoTJobExponentialRolloutRate.Builder#build()} is called
         * immediately and its result is passed to {@link #exponentialRate(IoTJobExponentialRolloutRate)}.
         * 
         * @param exponentialRate
         *        a consumer that will call methods on {@link IoTJobExponentialRolloutRate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exponentialRate(IoTJobExponentialRolloutRate)
         */
        default Builder exponentialRate(Consumer<IoTJobExponentialRolloutRate.Builder> exponentialRate) {
            return exponentialRate(IoTJobExponentialRolloutRate.builder().applyMutation(exponentialRate).build());
        }

        /**
         * <p>
         * The maximum number of devices that receive a pending job notification, per minute.
         * </p>
         * 
         * @param maximumPerMinute
         *        The maximum number of devices that receive a pending job notification, per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPerMinute(Integer maximumPerMinute);
    }

    static final class BuilderImpl implements Builder {
        private IoTJobExponentialRolloutRate exponentialRate;

        private Integer maximumPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobExecutionsRolloutConfig model) {
            exponentialRate(model.exponentialRate);
            maximumPerMinute(model.maximumPerMinute);
        }

        public final IoTJobExponentialRolloutRate.Builder getExponentialRate() {
            return exponentialRate != null ? exponentialRate.toBuilder() : null;
        }

        public final void setExponentialRate(IoTJobExponentialRolloutRate.BuilderImpl exponentialRate) {
            this.exponentialRate = exponentialRate != null ? exponentialRate.build() : null;
        }

        @Override
        public final Builder exponentialRate(IoTJobExponentialRolloutRate exponentialRate) {
            this.exponentialRate = exponentialRate;
            return this;
        }

        public final Integer getMaximumPerMinute() {
            return maximumPerMinute;
        }

        public final void setMaximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
        }

        @Override
        public final Builder maximumPerMinute(Integer maximumPerMinute) {
            this.maximumPerMinute = maximumPerMinute;
            return this;
        }

        @Override
        public IoTJobExecutionsRolloutConfig build() {
            return new IoTJobExecutionsRolloutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
