/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a component on a Greengrass core device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstalledComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<InstalledComponent.Builder, InstalledComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(InstalledComponent::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(InstalledComponent::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleState").getter(getter(InstalledComponent::lifecycleStateAsString))
            .setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleState").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStateDetails").getter(getter(InstalledComponent::lifecycleStateDetails))
            .setter(setter(Builder::lifecycleStateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStateDetails").build())
            .build();

    private static final SdkField<Boolean> IS_ROOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isRoot").getter(getter(InstalledComponent::isRoot)).setter(setter(Builder::isRoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isRoot").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("lastStatusChangeTimestamp")
            .getter(getter(InstalledComponent::lastStatusChangeTimestamp)).setter(setter(Builder::lastStatusChangeTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeTimestamp").build())
            .build();

    private static final SdkField<Instant> LAST_REPORTED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastReportedTimestamp").getter(getter(InstalledComponent::lastReportedTimestamp))
            .setter(setter(Builder::lastReportedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastReportedTimestamp").build())
            .build();

    private static final SdkField<String> LAST_INSTALLATION_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastInstallationSource").getter(getter(InstalledComponent::lastInstallationSource))
            .setter(setter(Builder::lastInstallationSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastInstallationSource").build())
            .build();

    private static final SdkField<List<String>> LIFECYCLE_STATUS_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("lifecycleStatusCodes")
            .getter(getter(InstalledComponent::lifecycleStatusCodes))
            .setter(setter(Builder::lifecycleStatusCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_VERSION_FIELD, LIFECYCLE_STATE_FIELD, LIFECYCLE_STATE_DETAILS_FIELD, IS_ROOT_FIELD,
            LAST_STATUS_CHANGE_TIMESTAMP_FIELD, LAST_REPORTED_TIMESTAMP_FIELD, LAST_INSTALLATION_SOURCE_FIELD,
            LIFECYCLE_STATUS_CODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String componentVersion;

    private final String lifecycleState;

    private final String lifecycleStateDetails;

    private final Boolean isRoot;

    private final Instant lastStatusChangeTimestamp;

    private final Instant lastReportedTimestamp;

    private final String lastInstallationSource;

    private final List<String> lifecycleStatusCodes;

    private InstalledComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.lifecycleState = builder.lifecycleState;
        this.lifecycleStateDetails = builder.lifecycleStateDetails;
        this.isRoot = builder.isRoot;
        this.lastStatusChangeTimestamp = builder.lastStatusChangeTimestamp;
        this.lastReportedTimestamp = builder.lastReportedTimestamp;
        this.lastInstallationSource = builder.lastInstallationSource;
        this.lifecycleStatusCodes = builder.lifecycleStatusCodes;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * The lifecycle state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link InstalledComponentLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle state of the component.
     * @see InstalledComponentLifecycleState
     */
    public final InstalledComponentLifecycleState lifecycleState() {
        return InstalledComponentLifecycleState.fromValue(lifecycleState);
    }

    /**
     * <p>
     * The lifecycle state of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleState}
     * will return {@link InstalledComponentLifecycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle state of the component.
     * @see InstalledComponentLifecycleState
     */
    public final String lifecycleStateAsString() {
        return lifecycleState;
    }

    /**
     * <p>
     * A detailed response about the lifecycle state of the component that explains the reason why a component has an
     * error or is broken.
     * </p>
     * 
     * @return A detailed response about the lifecycle state of the component that explains the reason why a component
     *         has an error or is broken.
     */
    public final String lifecycleStateDetails() {
        return lifecycleStateDetails;
    }

    /**
     * <p>
     * Whether or not the component is a root component.
     * </p>
     * 
     * @return Whether or not the component is a root component.
     */
    public final Boolean isRoot() {
        return isRoot;
    }

    /**
     * <p>
     * The status of how current the data is.
     * </p>
     * <p>
     * This response is based off of component state changes. The status reflects component disruptions and deployments.
     * If a component only sees a configuration update during a deployment, it might not undergo a state change and this
     * status would not be updated.
     * </p>
     * 
     * @return The status of how current the data is.</p>
     *         <p>
     *         This response is based off of component state changes. The status reflects component disruptions and
     *         deployments. If a component only sees a configuration update during a deployment, it might not undergo a
     *         state change and this status would not be updated.
     */
    public final Instant lastStatusChangeTimestamp() {
        return lastStatusChangeTimestamp;
    }

    /**
     * <p>
     * The last time the Greengrass core device sent a message containing a component's state to the Amazon Web Services
     * Cloud.
     * </p>
     * <p>
     * A component does not need to see a state change for this field to update.
     * </p>
     * 
     * @return The last time the Greengrass core device sent a message containing a component's state to the Amazon Web
     *         Services Cloud.</p>
     *         <p>
     *         A component does not need to see a state change for this field to update.
     */
    public final Instant lastReportedTimestamp() {
        return lastReportedTimestamp;
    }

    /**
     * <p>
     * The most recent deployment source that brought the component to the Greengrass core device. For a thing group
     * deployment or thing deployment, the source will be the ID of the last deployment that contained the component.
     * For local deployments it will be <code>LOCAL</code>.
     * </p>
     * <note>
     * <p>
     * Any deployment will attempt to reinstall currently broken components on the device, which will update the last
     * installation source.
     * </p>
     * </note>
     * 
     * @return The most recent deployment source that brought the component to the Greengrass core device. For a thing
     *         group deployment or thing deployment, the source will be the ID of the last deployment that contained the
     *         component. For local deployments it will be <code>LOCAL</code>.</p> <note>
     *         <p>
     *         Any deployment will attempt to reinstall currently broken components on the device, which will update the
     *         last installation source.
     *         </p>
     */
    public final String lastInstallationSource() {
        return lastInstallationSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecycleStatusCodes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifecycleStatusCodes() {
        return lifecycleStatusCodes != null && !(lifecycleStatusCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an error or is
     * in a broken state.
     * </p>
     * <note>
     * <p>
     * Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code> response.
     * This response can be inaccurate in earlier Greengrass nucleus versions.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecycleStatusCodes} method.
     * </p>
     * 
     * @return The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an
     *         error or is in a broken state.</p> <note>
     *         <p>
     *         Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code>
     *         response. This response can be inaccurate in earlier Greengrass nucleus versions.
     *         </p>
     */
    public final List<String> lifecycleStatusCodes() {
        return lifecycleStatusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(isRoot());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChangeTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastReportedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastInstallationSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecycleStatusCodes() ? lifecycleStatusCodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstalledComponent)) {
            return false;
        }
        InstalledComponent other = (InstalledComponent) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(lifecycleStateAsString(), other.lifecycleStateAsString())
                && Objects.equals(lifecycleStateDetails(), other.lifecycleStateDetails())
                && Objects.equals(isRoot(), other.isRoot())
                && Objects.equals(lastStatusChangeTimestamp(), other.lastStatusChangeTimestamp())
                && Objects.equals(lastReportedTimestamp(), other.lastReportedTimestamp())
                && Objects.equals(lastInstallationSource(), other.lastInstallationSource())
                && hasLifecycleStatusCodes() == other.hasLifecycleStatusCodes()
                && Objects.equals(lifecycleStatusCodes(), other.lifecycleStatusCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstalledComponent").add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion()).add("LifecycleState", lifecycleStateAsString())
                .add("LifecycleStateDetails", lifecycleStateDetails()).add("IsRoot", isRoot())
                .add("LastStatusChangeTimestamp", lastStatusChangeTimestamp())
                .add("LastReportedTimestamp", lastReportedTimestamp()).add("LastInstallationSource", lastInstallationSource())
                .add("LifecycleStatusCodes", hasLifecycleStatusCodes() ? lifecycleStatusCodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "lifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleStateAsString()));
        case "lifecycleStateDetails":
            return Optional.ofNullable(clazz.cast(lifecycleStateDetails()));
        case "isRoot":
            return Optional.ofNullable(clazz.cast(isRoot()));
        case "lastStatusChangeTimestamp":
            return Optional.ofNullable(clazz.cast(lastStatusChangeTimestamp()));
        case "lastReportedTimestamp":
            return Optional.ofNullable(clazz.cast(lastReportedTimestamp()));
        case "lastInstallationSource":
            return Optional.ofNullable(clazz.cast(lastInstallationSource()));
        case "lifecycleStatusCodes":
            return Optional.ofNullable(clazz.cast(lifecycleStatusCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("lifecycleState", LIFECYCLE_STATE_FIELD);
        map.put("lifecycleStateDetails", LIFECYCLE_STATE_DETAILS_FIELD);
        map.put("isRoot", IS_ROOT_FIELD);
        map.put("lastStatusChangeTimestamp", LAST_STATUS_CHANGE_TIMESTAMP_FIELD);
        map.put("lastReportedTimestamp", LAST_REPORTED_TIMESTAMP_FIELD);
        map.put("lastInstallationSource", LAST_INSTALLATION_SOURCE_FIELD);
        map.put("lifecycleStatusCodes", LIFECYCLE_STATUS_CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstalledComponent, T> g) {
        return obj -> g.apply((InstalledComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstalledComponent> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The lifecycle state of the component.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state of the component.
         * @see InstalledComponentLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentLifecycleState
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The lifecycle state of the component.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state of the component.
         * @see InstalledComponentLifecycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstalledComponentLifecycleState
         */
        Builder lifecycleState(InstalledComponentLifecycleState lifecycleState);

        /**
         * <p>
         * A detailed response about the lifecycle state of the component that explains the reason why a component has
         * an error or is broken.
         * </p>
         * 
         * @param lifecycleStateDetails
         *        A detailed response about the lifecycle state of the component that explains the reason why a
         *        component has an error or is broken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStateDetails(String lifecycleStateDetails);

        /**
         * <p>
         * Whether or not the component is a root component.
         * </p>
         * 
         * @param isRoot
         *        Whether or not the component is a root component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRoot(Boolean isRoot);

        /**
         * <p>
         * The status of how current the data is.
         * </p>
         * <p>
         * This response is based off of component state changes. The status reflects component disruptions and
         * deployments. If a component only sees a configuration update during a deployment, it might not undergo a
         * state change and this status would not be updated.
         * </p>
         * 
         * @param lastStatusChangeTimestamp
         *        The status of how current the data is.</p>
         *        <p>
         *        This response is based off of component state changes. The status reflects component disruptions and
         *        deployments. If a component only sees a configuration update during a deployment, it might not undergo
         *        a state change and this status would not be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChangeTimestamp(Instant lastStatusChangeTimestamp);

        /**
         * <p>
         * The last time the Greengrass core device sent a message containing a component's state to the Amazon Web
         * Services Cloud.
         * </p>
         * <p>
         * A component does not need to see a state change for this field to update.
         * </p>
         * 
         * @param lastReportedTimestamp
         *        The last time the Greengrass core device sent a message containing a component's state to the Amazon
         *        Web Services Cloud.</p>
         *        <p>
         *        A component does not need to see a state change for this field to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastReportedTimestamp(Instant lastReportedTimestamp);

        /**
         * <p>
         * The most recent deployment source that brought the component to the Greengrass core device. For a thing group
         * deployment or thing deployment, the source will be the ID of the last deployment that contained the
         * component. For local deployments it will be <code>LOCAL</code>.
         * </p>
         * <note>
         * <p>
         * Any deployment will attempt to reinstall currently broken components on the device, which will update the
         * last installation source.
         * </p>
         * </note>
         * 
         * @param lastInstallationSource
         *        The most recent deployment source that brought the component to the Greengrass core device. For a
         *        thing group deployment or thing deployment, the source will be the ID of the last deployment that
         *        contained the component. For local deployments it will be <code>LOCAL</code>.</p> <note>
         *        <p>
         *        Any deployment will attempt to reinstall currently broken components on the device, which will update
         *        the last installation source.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastInstallationSource(String lastInstallationSource);

        /**
         * <p>
         * The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an error
         * or is in a broken state.
         * </p>
         * <note>
         * <p>
         * Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code> response.
         * This response can be inaccurate in earlier Greengrass nucleus versions.
         * </p>
         * </note>
         * 
         * @param lifecycleStatusCodes
         *        The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an
         *        error or is in a broken state.</p> <note>
         *        <p>
         *        Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code>
         *        response. This response can be inaccurate in earlier Greengrass nucleus versions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusCodes(Collection<String> lifecycleStatusCodes);

        /**
         * <p>
         * The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an error
         * or is in a broken state.
         * </p>
         * <note>
         * <p>
         * Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code> response.
         * This response can be inaccurate in earlier Greengrass nucleus versions.
         * </p>
         * </note>
         * 
         * @param lifecycleStatusCodes
         *        The status codes that indicate the reason for failure whenever the <code>lifecycleState</code> has an
         *        error or is in a broken state.</p> <note>
         *        <p>
         *        Greengrass nucleus v2.8.0 or later is required to get an accurate <code>lifecycleStatusCodes</code>
         *        response. This response can be inaccurate in earlier Greengrass nucleus versions.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusCodes(String... lifecycleStatusCodes);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String componentVersion;

        private String lifecycleState;

        private String lifecycleStateDetails;

        private Boolean isRoot;

        private Instant lastStatusChangeTimestamp;

        private Instant lastReportedTimestamp;

        private String lastInstallationSource;

        private List<String> lifecycleStatusCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstalledComponent model) {
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            lifecycleState(model.lifecycleState);
            lifecycleStateDetails(model.lifecycleStateDetails);
            isRoot(model.isRoot);
            lastStatusChangeTimestamp(model.lastStatusChangeTimestamp);
            lastReportedTimestamp(model.lastReportedTimestamp);
            lastInstallationSource(model.lastInstallationSource);
            lifecycleStatusCodes(model.lifecycleStatusCodes);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(InstalledComponentLifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState == null ? null : lifecycleState.toString());
            return this;
        }

        public final String getLifecycleStateDetails() {
            return lifecycleStateDetails;
        }

        public final void setLifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
        }

        @Override
        public final Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            return this;
        }

        public final Boolean getIsRoot() {
            return isRoot;
        }

        public final void setIsRoot(Boolean isRoot) {
            this.isRoot = isRoot;
        }

        @Override
        public final Builder isRoot(Boolean isRoot) {
            this.isRoot = isRoot;
            return this;
        }

        public final Instant getLastStatusChangeTimestamp() {
            return lastStatusChangeTimestamp;
        }

        public final void setLastStatusChangeTimestamp(Instant lastStatusChangeTimestamp) {
            this.lastStatusChangeTimestamp = lastStatusChangeTimestamp;
        }

        @Override
        public final Builder lastStatusChangeTimestamp(Instant lastStatusChangeTimestamp) {
            this.lastStatusChangeTimestamp = lastStatusChangeTimestamp;
            return this;
        }

        public final Instant getLastReportedTimestamp() {
            return lastReportedTimestamp;
        }

        public final void setLastReportedTimestamp(Instant lastReportedTimestamp) {
            this.lastReportedTimestamp = lastReportedTimestamp;
        }

        @Override
        public final Builder lastReportedTimestamp(Instant lastReportedTimestamp) {
            this.lastReportedTimestamp = lastReportedTimestamp;
            return this;
        }

        public final String getLastInstallationSource() {
            return lastInstallationSource;
        }

        public final void setLastInstallationSource(String lastInstallationSource) {
            this.lastInstallationSource = lastInstallationSource;
        }

        @Override
        public final Builder lastInstallationSource(String lastInstallationSource) {
            this.lastInstallationSource = lastInstallationSource;
            return this;
        }

        public final Collection<String> getLifecycleStatusCodes() {
            if (lifecycleStatusCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecycleStatusCodes;
        }

        public final void setLifecycleStatusCodes(Collection<String> lifecycleStatusCodes) {
            this.lifecycleStatusCodes = InstalledComponentLifecycleStatusCodeListCopier.copy(lifecycleStatusCodes);
        }

        @Override
        public final Builder lifecycleStatusCodes(Collection<String> lifecycleStatusCodes) {
            this.lifecycleStatusCodes = InstalledComponentLifecycleStatusCodeListCopier.copy(lifecycleStatusCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleStatusCodes(String... lifecycleStatusCodes) {
            lifecycleStatusCodes(Arrays.asList(lifecycleStatusCodes));
            return this;
        }

        @Override
        public InstalledComponent build() {
            return new InstalledComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
