/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentResponse extends GreengrassV2Response implements
        ToCopyableBuilder<DescribeComponentResponse.Builder, DescribeComponentResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeComponentResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentName").getter(getter(DescribeComponentResponse::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()).build();

    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentVersion").getter(getter(DescribeComponentResponse::componentVersion))
            .setter(setter(Builder::componentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()).build();

    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTimestamp").getter(getter(DescribeComponentResponse::creationTimestamp))
            .setter(setter(Builder::creationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()).build();

    private static final SdkField<String> PUBLISHER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publisher").getter(getter(DescribeComponentResponse::publisher)).setter(setter(Builder::publisher))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeComponentResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<CloudComponentStatus> STATUS_FIELD = SdkField
            .<CloudComponentStatus> builder(MarshallingType.SDK_POJO).memberName("status")
            .getter(getter(DescribeComponentResponse::status)).setter(setter(Builder::status))
            .constructor(CloudComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<ComponentPlatform>> PLATFORMS_FIELD = SdkField
            .<List<ComponentPlatform>> builder(MarshallingType.LIST)
            .memberName("platforms")
            .getter(getter(DescribeComponentResponse::platforms))
            .setter(setter(Builder::platforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentPlatform> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentPlatform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeComponentResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, CREATION_TIMESTAMP_FIELD, PUBLISHER_FIELD, DESCRIPTION_FIELD,
            STATUS_FIELD, PLATFORMS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String componentName;

    private final String componentVersion;

    private final Instant creationTimestamp;

    private final String publisher;

    private final String description;

    private final CloudComponentStatus status;

    private final List<ComponentPlatform> platforms;

    private final Map<String, String> tags;

    private DescribeComponentResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.creationTimestamp = builder.creationTimestamp;
        this.publisher = builder.publisher;
        this.description = builder.description;
        this.status = builder.status;
        this.platforms = builder.platforms;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         component version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */
    public final String componentVersion() {
        return componentVersion;
    }

    /**
     * <p>
     * The time at which the component was created, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time at which the component was created, expressed in ISO 8601 format.
     */
    public final Instant creationTimestamp() {
        return creationTimestamp;
    }

    /**
     * <p>
     * The publisher of the component version.
     * </p>
     * 
     * @return The publisher of the component version.
     */
    public final String publisher() {
        return publisher;
    }

    /**
     * <p>
     * The description of the component version.
     * </p>
     * 
     * @return The description of the component version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the component version in IoT Greengrass V2. This status is different from the status of the
     * component on a core device.
     * </p>
     * 
     * @return The status of the component version in IoT Greengrass V2. This status is different from the status of the
     *         component on a core device.
     */
    public final CloudComponentStatus status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Platforms property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlatforms() {
        return platforms != null && !(platforms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The platforms that the component version supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatforms} method.
     * </p>
     * 
     * @return The platforms that the component version supports.
     */
    public final List<ComponentPlatform> platforms() {
        return platforms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the resource. For more information, see <a
     * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in the
     * <i>IoT Greengrass V2 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a>
     *         in the <i>IoT Greengrass V2 Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(publisher());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatforms() ? platforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentResponse)) {
            return false;
        }
        DescribeComponentResponse other = (DescribeComponentResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentVersion(), other.componentVersion())
                && Objects.equals(creationTimestamp(), other.creationTimestamp())
                && Objects.equals(publisher(), other.publisher()) && Objects.equals(description(), other.description())
                && Objects.equals(status(), other.status()) && hasPlatforms() == other.hasPlatforms()
                && Objects.equals(platforms(), other.platforms()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComponentResponse").add("Arn", arn()).add("ComponentName", componentName())
                .add("ComponentVersion", componentVersion()).add("CreationTimestamp", creationTimestamp())
                .add("Publisher", publisher()).add("Description", description()).add("Status", status())
                .add("Platforms", hasPlatforms() ? platforms() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "componentVersion":
            return Optional.ofNullable(clazz.cast(componentVersion()));
        case "creationTimestamp":
            return Optional.ofNullable(clazz.cast(creationTimestamp()));
        case "publisher":
            return Optional.ofNullable(clazz.cast(publisher()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "platforms":
            return Optional.ofNullable(clazz.cast(platforms()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("platforms", PLATFORMS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentResponse, T> g) {
        return obj -> g.apply((DescribeComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GreengrassV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeComponentResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * component version.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The version of the component.
         * </p>
         * 
         * @param componentVersion
         *        The version of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentVersion(String componentVersion);

        /**
         * <p>
         * The time at which the component was created, expressed in ISO 8601 format.
         * </p>
         * 
         * @param creationTimestamp
         *        The time at which the component was created, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimestamp(Instant creationTimestamp);

        /**
         * <p>
         * The publisher of the component version.
         * </p>
         * 
         * @param publisher
         *        The publisher of the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publisher(String publisher);

        /**
         * <p>
         * The description of the component version.
         * </p>
         * 
         * @param description
         *        The description of the component version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the
         * component on a core device.
         * </p>
         * 
         * @param status
         *        The status of the component version in IoT Greengrass V2. This status is different from the status of
         *        the component on a core device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(CloudComponentStatus status);

        /**
         * <p>
         * The status of the component version in IoT Greengrass V2. This status is different from the status of the
         * component on a core device.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudComponentStatus.Builder} avoiding
         * the need to create one manually via {@link CloudComponentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(CloudComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link CloudComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(CloudComponentStatus)
         */
        default Builder status(Consumer<CloudComponentStatus.Builder> status) {
            return status(CloudComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * 
         * @param platforms
         *        The platforms that the component version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(Collection<ComponentPlatform> platforms);

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * 
         * @param platforms
         *        The platforms that the component version supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platforms(ComponentPlatform... platforms);

        /**
         * <p>
         * The platforms that the component version supports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder#build()} is called
         * immediately and its result is passed to {@link #platforms(List<ComponentPlatform>)}.
         * 
         * @param platforms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platforms(java.util.Collection<ComponentPlatform>)
         */
        Builder platforms(Consumer<ComponentPlatform.Builder>... platforms);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the resource. For more information, see <a
         * href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your resources</a> in
         * the <i>IoT Greengrass V2 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your
         *        resources</a> in the <i>IoT Greengrass V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GreengrassV2Response.BuilderImpl implements Builder {
        private String arn;

        private String componentName;

        private String componentVersion;

        private Instant creationTimestamp;

        private String publisher;

        private String description;

        private CloudComponentStatus status;

        private List<ComponentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentResponse model) {
            super(model);
            arn(model.arn);
            componentName(model.componentName);
            componentVersion(model.componentVersion);
            creationTimestamp(model.creationTimestamp);
            publisher(model.publisher);
            description(model.description);
            status(model.status);
            platforms(model.platforms);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getPublisher() {
            return publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final CloudComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(CloudComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CloudComponentStatus status) {
            this.status = status;
            return this;
        }

        public final List<ComponentPlatform.Builder> getPlatforms() {
            List<ComponentPlatform.Builder> result = ComponentPlatformListCopier.copyToBuilder(this.platforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatforms(Collection<ComponentPlatform.BuilderImpl> platforms) {
            this.platforms = ComponentPlatformListCopier.copyFromBuilder(platforms);
        }

        @Override
        public final Builder platforms(Collection<ComponentPlatform> platforms) {
            this.platforms = ComponentPlatformListCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(ComponentPlatform... platforms) {
            platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<ComponentPlatform.Builder>... platforms) {
            platforms(Stream.of(platforms).map(c -> ComponentPlatform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeComponentResponse build() {
            return new DescribeComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
