/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a client device that is associated to a core device for cloud discovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedClientDevice implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedClientDevice.Builder, AssociatedClientDevice> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(AssociatedClientDevice::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<Instant> ASSOCIATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("associationTimestamp").getter(getter(AssociatedClientDevice::associationTimestamp))
            .setter(setter(Builder::associationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            ASSOCIATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final Instant associationTimestamp;

    private AssociatedClientDevice(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.associationTimestamp = builder.associationTimestamp;
    }

    /**
     * <p>
     * The name of the IoT thing that represents the associated client device.
     * </p>
     * 
     * @return The name of the IoT thing that represents the associated client device.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The time that the client device was associated, expressed in ISO 8601 format.
     * </p>
     * 
     * @return The time that the client device was associated, expressed in ISO 8601 format.
     */
    public final Instant associationTimestamp() {
        return associationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(associationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedClientDevice)) {
            return false;
        }
        AssociatedClientDevice other = (AssociatedClientDevice) obj;
        return Objects.equals(thingName(), other.thingName())
                && Objects.equals(associationTimestamp(), other.associationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedClientDevice").add("ThingName", thingName())
                .add("AssociationTimestamp", associationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "associationTimestamp":
            return Optional.ofNullable(clazz.cast(associationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("associationTimestamp", ASSOCIATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedClientDevice, T> g) {
        return obj -> g.apply((AssociatedClientDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedClientDevice> {
        /**
         * <p>
         * The name of the IoT thing that represents the associated client device.
         * </p>
         * 
         * @param thingName
         *        The name of the IoT thing that represents the associated client device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The time that the client device was associated, expressed in ISO 8601 format.
         * </p>
         * 
         * @param associationTimestamp
         *        The time that the client device was associated, expressed in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTimestamp(Instant associationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private Instant associationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedClientDevice model) {
            thingName(model.thingName);
            associationTimestamp(model.associationTimestamp);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Instant getAssociationTimestamp() {
            return associationTimestamp;
        }

        public final void setAssociationTimestamp(Instant associationTimestamp) {
            this.associationTimestamp = associationTimestamp;
        }

        @Override
        public final Builder associationTimestamp(Instant associationTimestamp) {
            this.associationTimestamp = associationTimestamp;
            return this;
        }

        @Override
        public AssociatedClientDevice build() {
            return new AssociatedClientDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
