/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(Deployment.getter(Deployment::targetArn)).setter(Deployment.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(Deployment.getter(Deployment::revisionId)).setter(Deployment.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(Deployment.getter(Deployment::deploymentId)).setter(Deployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentName").getter(Deployment.getter(Deployment::deploymentName)).setter(Deployment.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(Deployment.getter(Deployment::creationTimestamp)).setter(Deployment.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(Deployment.getter(Deployment::deploymentStatusAsString)).setter(Deployment.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_FOR_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLatestForTarget").getter(Deployment.getter(Deployment::isLatestForTarget)).setter(Deployment.setter(Builder::isLatestForTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLatestForTarget").build()}).build();
    private static final SdkField<String> PARENT_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentTargetArn").getter(Deployment.getter(Deployment::parentTargetArn)).setter(Deployment.setter(Builder::parentTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentTargetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, REVISION_ID_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_NAME_FIELD, CREATION_TIMESTAMP_FIELD, DEPLOYMENT_STATUS_FIELD, IS_LATEST_FOR_TARGET_FIELD, PARENT_TARGET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Deployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetArn;
    private final String revisionId;
    private final String deploymentId;
    private final String deploymentName;
    private final Instant creationTimestamp;
    private final String deploymentStatus;
    private final Boolean isLatestForTarget;
    private final String parentTargetArn;

    private Deployment(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.revisionId = builder.revisionId;
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.creationTimestamp = builder.creationTimestamp;
        this.deploymentStatus = builder.deploymentStatus;
        this.isLatestForTarget = builder.isLatestForTarget;
        this.parentTargetArn = builder.parentTargetArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String deploymentName() {
        return this.deploymentName;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final Boolean isLatestForTarget() {
        return this.isLatestForTarget;
    }

    public final String parentTargetArn() {
        return this.parentTargetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestForTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentTargetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.isLatestForTarget(), other.isLatestForTarget()) && Objects.equals(this.parentTargetArn(), other.parentTargetArn());
    }

    public final String toString() {
        return ToString.builder((String)"Deployment").add("TargetArn", (Object)this.targetArn()).add("RevisionId", (Object)this.revisionId()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentName", (Object)this.deploymentName()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("IsLatestForTarget", (Object)this.isLatestForTarget()).add("ParentTargetArn", (Object)this.parentTargetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "deploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "isLatestForTarget": {
                return Optional.ofNullable(clazz.cast(this.isLatestForTarget()));
            }
            case "parentTargetArn": {
                return Optional.ofNullable(clazz.cast(this.parentTargetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("deploymentName", DEPLOYMENT_NAME_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("isLatestForTarget", IS_LATEST_FOR_TARGET_FIELD);
        map.put("parentTargetArn", PARENT_TARGET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetArn;
        private String revisionId;
        private String deploymentId;
        private String deploymentName;
        private Instant creationTimestamp;
        private String deploymentStatus;
        private Boolean isLatestForTarget;
        private String parentTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.targetArn(model.targetArn);
            this.revisionId(model.revisionId);
            this.deploymentId(model.deploymentId);
            this.deploymentName(model.deploymentName);
            this.creationTimestamp(model.creationTimestamp);
            this.deploymentStatus(model.deploymentStatus);
            this.isLatestForTarget(model.isLatestForTarget);
            this.parentTargetArn(model.parentTargetArn);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final Boolean getIsLatestForTarget() {
            return this.isLatestForTarget;
        }

        public final void setIsLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
        }

        @Override
        public final Builder isLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
            return this;
        }

        public final String getParentTargetArn() {
            return this.parentTargetArn;
        }

        public final void setParentTargetArn(String parentTargetArn) {
            this.parentTargetArn = parentTargetArn;
        }

        @Override
        public final Builder parentTargetArn(String parentTargetArn) {
            this.parentTargetArn = parentTargetArn;
            return this;
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder targetArn(String var1);

        public Builder revisionId(String var1);

        public Builder deploymentId(String var1);

        public Builder deploymentName(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder isLatestForTarget(Boolean var1);

        public Builder parentTargetArn(String var1);
    }
}

