/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.LambdaFilesystemPermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaDeviceMount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaDeviceMount> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(LambdaDeviceMount.getter(LambdaDeviceMount::path)).setter(LambdaDeviceMount.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permission").getter(LambdaDeviceMount.getter(LambdaDeviceMount::permissionAsString)).setter(LambdaDeviceMount.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()}).build();
    private static final SdkField<Boolean> ADD_GROUP_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("addGroupOwner").getter(LambdaDeviceMount.getter(LambdaDeviceMount::addGroupOwner)).setter(LambdaDeviceMount.setter(Builder::addGroupOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addGroupOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, PERMISSION_FIELD, ADD_GROUP_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaDeviceMount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String permission;
    private final Boolean addGroupOwner;

    private LambdaDeviceMount(BuilderImpl builder) {
        this.path = builder.path;
        this.permission = builder.permission;
        this.addGroupOwner = builder.addGroupOwner;
    }

    public final String path() {
        return this.path;
    }

    public final LambdaFilesystemPermission permission() {
        return LambdaFilesystemPermission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final Boolean addGroupOwner() {
        return this.addGroupOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addGroupOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaDeviceMount)) {
            return false;
        }
        LambdaDeviceMount other = (LambdaDeviceMount)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.addGroupOwner(), other.addGroupOwner());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaDeviceMount").add("Path", (Object)this.path()).add("Permission", (Object)this.permissionAsString()).add("AddGroupOwner", (Object)this.addGroupOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "addGroupOwner": {
                return Optional.ofNullable(clazz.cast(this.addGroupOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("path", PATH_FIELD);
        map.put("permission", PERMISSION_FIELD);
        map.put("addGroupOwner", ADD_GROUP_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaDeviceMount, T> g) {
        return obj -> g.apply((LambdaDeviceMount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String permission;
        private Boolean addGroupOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaDeviceMount model) {
            this.path(model.path);
            this.permission(model.permission);
            this.addGroupOwner(model.addGroupOwner);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(LambdaFilesystemPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Boolean getAddGroupOwner() {
            return this.addGroupOwner;
        }

        public final void setAddGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
        }

        @Override
        public final Builder addGroupOwner(Boolean addGroupOwner) {
            this.addGroupOwner = addGroupOwner;
            return this;
        }

        public LambdaDeviceMount build() {
            return new LambdaDeviceMount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaDeviceMount> {
        public Builder path(String var1);

        public Builder permission(String var1);

        public Builder permission(LambdaFilesystemPermission var1);

        public Builder addGroupOwner(Boolean var1);
    }
}

