/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.CloudComponentState;
import software.amazon.awssdk.services.greengrassv2.model.StringMapCopier;
import software.amazon.awssdk.services.greengrassv2.model.VendorGuidance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudComponentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudComponentStatus> {
    private static final SdkField<String> COMPONENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentState").getter(CloudComponentStatus.getter(CloudComponentStatus::componentStateAsString)).setter(CloudComponentStatus.setter(Builder::componentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentState").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(CloudComponentStatus.getter(CloudComponentStatus::message)).setter(CloudComponentStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Map<String, String>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("errors").getter(CloudComponentStatus.getter(CloudComponentStatus::errors)).setter(CloudComponentStatus.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendorGuidance").getter(CloudComponentStatus.getter(CloudComponentStatus::vendorGuidanceAsString)).setter(CloudComponentStatus.setter(Builder::vendorGuidance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorGuidance").build()}).build();
    private static final SdkField<String> VENDOR_GUIDANCE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vendorGuidanceMessage").getter(CloudComponentStatus.getter(CloudComponentStatus::vendorGuidanceMessage)).setter(CloudComponentStatus.setter(Builder::vendorGuidanceMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorGuidanceMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_STATE_FIELD, MESSAGE_FIELD, ERRORS_FIELD, VENDOR_GUIDANCE_FIELD, VENDOR_GUIDANCE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudComponentStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentState;
    private final String message;
    private final Map<String, String> errors;
    private final String vendorGuidance;
    private final String vendorGuidanceMessage;

    private CloudComponentStatus(BuilderImpl builder) {
        this.componentState = builder.componentState;
        this.message = builder.message;
        this.errors = builder.errors;
        this.vendorGuidance = builder.vendorGuidance;
        this.vendorGuidanceMessage = builder.vendorGuidanceMessage;
    }

    public final CloudComponentState componentState() {
        return CloudComponentState.fromValue(this.componentState);
    }

    public final String componentStateAsString() {
        return this.componentState;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> errors() {
        return this.errors;
    }

    public final VendorGuidance vendorGuidance() {
        return VendorGuidance.fromValue(this.vendorGuidance);
    }

    public final String vendorGuidanceAsString() {
        return this.vendorGuidance;
    }

    public final String vendorGuidanceMessage() {
        return this.vendorGuidanceMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vendorGuidanceMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudComponentStatus)) {
            return false;
        }
        CloudComponentStatus other = (CloudComponentStatus)obj;
        return Objects.equals(this.componentStateAsString(), other.componentStateAsString()) && Objects.equals(this.message(), other.message()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.vendorGuidanceAsString(), other.vendorGuidanceAsString()) && Objects.equals(this.vendorGuidanceMessage(), other.vendorGuidanceMessage());
    }

    public final String toString() {
        return ToString.builder((String)"CloudComponentStatus").add("ComponentState", (Object)this.componentStateAsString()).add("Message", (Object)this.message()).add("Errors", this.hasErrors() ? this.errors() : null).add("VendorGuidance", (Object)this.vendorGuidanceAsString()).add("VendorGuidanceMessage", (Object)this.vendorGuidanceMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentState": {
                return Optional.ofNullable(clazz.cast(this.componentStateAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "vendorGuidance": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceAsString()));
            }
            case "vendorGuidanceMessage": {
                return Optional.ofNullable(clazz.cast(this.vendorGuidanceMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentState", COMPONENT_STATE_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("vendorGuidance", VENDOR_GUIDANCE_FIELD);
        map.put("vendorGuidanceMessage", VENDOR_GUIDANCE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudComponentStatus, T> g) {
        return obj -> g.apply((CloudComponentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentState;
        private String message;
        private Map<String, String> errors = DefaultSdkAutoConstructMap.getInstance();
        private String vendorGuidance;
        private String vendorGuidanceMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudComponentStatus model) {
            this.componentState(model.componentState);
            this.message(model.message);
            this.errors(model.errors);
            this.vendorGuidance(model.vendorGuidance);
            this.vendorGuidanceMessage(model.vendorGuidanceMessage);
        }

        public final String getComponentState() {
            return this.componentState;
        }

        public final void setComponentState(String componentState) {
            this.componentState = componentState;
        }

        @Override
        public final Builder componentState(String componentState) {
            this.componentState = componentState;
            return this;
        }

        @Override
        public final Builder componentState(CloudComponentState componentState) {
            this.componentState(componentState == null ? null : componentState.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Map<String, String> getErrors() {
            if (this.errors instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.errors;
        }

        public final void setErrors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
        }

        @Override
        public final Builder errors(Map<String, String> errors) {
            this.errors = StringMapCopier.copy(errors);
            return this;
        }

        public final String getVendorGuidance() {
            return this.vendorGuidance;
        }

        public final void setVendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
        }

        @Override
        public final Builder vendorGuidance(String vendorGuidance) {
            this.vendorGuidance = vendorGuidance;
            return this;
        }

        @Override
        public final Builder vendorGuidance(VendorGuidance vendorGuidance) {
            this.vendorGuidance(vendorGuidance == null ? null : vendorGuidance.toString());
            return this;
        }

        public final String getVendorGuidanceMessage() {
            return this.vendorGuidanceMessage;
        }

        public final void setVendorGuidanceMessage(String vendorGuidanceMessage) {
            this.vendorGuidanceMessage = vendorGuidanceMessage;
        }

        @Override
        public final Builder vendorGuidanceMessage(String vendorGuidanceMessage) {
            this.vendorGuidanceMessage = vendorGuidanceMessage;
            return this;
        }

        public CloudComponentStatus build() {
            return new CloudComponentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudComponentStatus> {
        public Builder componentState(String var1);

        public Builder componentState(CloudComponentState var1);

        public Builder message(String var1);

        public Builder errors(Map<String, String> var1);

        public Builder vendorGuidance(String var1);

        public Builder vendorGuidance(VendorGuidance var1);

        public Builder vendorGuidanceMessage(String var1);
    }
}

