/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2Client;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.ComponentVersionListItem;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse;

public class ListComponentVersionsIterable
implements SdkIterable<ListComponentVersionsResponse> {
    private final GreengrassV2Client client;
    private final ListComponentVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComponentVersionsIterable(GreengrassV2Client client, ListComponentVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComponentVersionsResponseFetcher();
    }

    public Iterator<ListComponentVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComponentVersionListItem> componentVersions() {
        Function<ListComponentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.componentVersions() != null) {
                return response.componentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComponentVersionsResponseFetcher
    implements SyncPageFetcher<ListComponentVersionsResponse> {
        private ListComponentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComponentVersionsResponse nextPage(ListComponentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentVersionsIterable.this.client.listComponentVersions(ListComponentVersionsIterable.this.firstRequest);
            }
            return ListComponentVersionsIterable.this.client.listComponentVersions((ListComponentVersionsRequest)((Object)ListComponentVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

