/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeploymentExecutionStatus;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeploymentStatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EffectiveDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EffectiveDeployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(EffectiveDeployment.getter(EffectiveDeployment::deploymentId)).setter(EffectiveDeployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentName").getter(EffectiveDeployment.getter(EffectiveDeployment::deploymentName)).setter(EffectiveDeployment.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()}).build();
    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobId").getter(EffectiveDeployment.getter(EffectiveDeployment::iotJobId)).setter(EffectiveDeployment.setter(Builder::iotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()}).build();
    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobArn").getter(EffectiveDeployment.getter(EffectiveDeployment::iotJobArn)).setter(EffectiveDeployment.setter(Builder::iotJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(EffectiveDeployment.getter(EffectiveDeployment::description)).setter(EffectiveDeployment.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(EffectiveDeployment.getter(EffectiveDeployment::targetArn)).setter(EffectiveDeployment.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> CORE_DEVICE_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreDeviceExecutionStatus").getter(EffectiveDeployment.getter(EffectiveDeployment::coreDeviceExecutionStatusAsString)).setter(EffectiveDeployment.setter(Builder::coreDeviceExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceExecutionStatus").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(EffectiveDeployment.getter(EffectiveDeployment::reason)).setter(EffectiveDeployment.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(EffectiveDeployment.getter(EffectiveDeployment::creationTimestamp)).setter(EffectiveDeployment.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedTimestamp").getter(EffectiveDeployment.getter(EffectiveDeployment::modifiedTimestamp)).setter(EffectiveDeployment.setter(Builder::modifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTimestamp").build()}).build();
    private static final SdkField<EffectiveDeploymentStatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(EffectiveDeployment.getter(EffectiveDeployment::statusDetails)).setter(EffectiveDeployment.setter(Builder::statusDetails)).constructor(EffectiveDeploymentStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, DEPLOYMENT_NAME_FIELD, IOT_JOB_ID_FIELD, IOT_JOB_ARN_FIELD, DESCRIPTION_FIELD, TARGET_ARN_FIELD, CORE_DEVICE_EXECUTION_STATUS_FIELD, REASON_FIELD, CREATION_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, STATUS_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EffectiveDeployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String deploymentName;
    private final String iotJobId;
    private final String iotJobArn;
    private final String description;
    private final String targetArn;
    private final String coreDeviceExecutionStatus;
    private final String reason;
    private final Instant creationTimestamp;
    private final Instant modifiedTimestamp;
    private final EffectiveDeploymentStatusDetails statusDetails;

    private EffectiveDeployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
        this.description = builder.description;
        this.targetArn = builder.targetArn;
        this.coreDeviceExecutionStatus = builder.coreDeviceExecutionStatus;
        this.reason = builder.reason;
        this.creationTimestamp = builder.creationTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.statusDetails = builder.statusDetails;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String deploymentName() {
        return this.deploymentName;
    }

    public final String iotJobId() {
        return this.iotJobId;
    }

    public final String iotJobArn() {
        return this.iotJobArn;
    }

    public final String description() {
        return this.description;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final EffectiveDeploymentExecutionStatus coreDeviceExecutionStatus() {
        return EffectiveDeploymentExecutionStatus.fromValue(this.coreDeviceExecutionStatus);
    }

    public final String coreDeviceExecutionStatusAsString() {
        return this.coreDeviceExecutionStatus;
    }

    public final String reason() {
        return this.reason;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant modifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public final EffectiveDeploymentStatusDetails statusDetails() {
        return this.statusDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDeviceExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveDeployment)) {
            return false;
        }
        EffectiveDeployment other = (EffectiveDeployment)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.iotJobId(), other.iotJobId()) && Objects.equals(this.iotJobArn(), other.iotJobArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.coreDeviceExecutionStatusAsString(), other.coreDeviceExecutionStatusAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.modifiedTimestamp(), other.modifiedTimestamp()) && Objects.equals(this.statusDetails(), other.statusDetails());
    }

    public final String toString() {
        return ToString.builder((String)"EffectiveDeployment").add("DeploymentId", (Object)this.deploymentId()).add("DeploymentName", (Object)this.deploymentName()).add("IotJobId", (Object)this.iotJobId()).add("IotJobArn", (Object)this.iotJobArn()).add("Description", (Object)this.description()).add("TargetArn", (Object)this.targetArn()).add("CoreDeviceExecutionStatus", (Object)this.coreDeviceExecutionStatusAsString()).add("Reason", (Object)this.reason()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("ModifiedTimestamp", (Object)this.modifiedTimestamp()).add("StatusDetails", (Object)this.statusDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "deploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "iotJobId": {
                return Optional.ofNullable(clazz.cast(this.iotJobId()));
            }
            case "iotJobArn": {
                return Optional.ofNullable(clazz.cast(this.iotJobArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "coreDeviceExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.coreDeviceExecutionStatusAsString()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "modifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.modifiedTimestamp()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("deploymentName", DEPLOYMENT_NAME_FIELD);
        map.put("iotJobId", IOT_JOB_ID_FIELD);
        map.put("iotJobArn", IOT_JOB_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("coreDeviceExecutionStatus", CORE_DEVICE_EXECUTION_STATUS_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("modifiedTimestamp", MODIFIED_TIMESTAMP_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EffectiveDeployment, T> g) {
        return obj -> g.apply((EffectiveDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String deploymentName;
        private String iotJobId;
        private String iotJobArn;
        private String description;
        private String targetArn;
        private String coreDeviceExecutionStatus;
        private String reason;
        private Instant creationTimestamp;
        private Instant modifiedTimestamp;
        private EffectiveDeploymentStatusDetails statusDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveDeployment model) {
            this.deploymentId(model.deploymentId);
            this.deploymentName(model.deploymentName);
            this.iotJobId(model.iotJobId);
            this.iotJobArn(model.iotJobArn);
            this.description(model.description);
            this.targetArn(model.targetArn);
            this.coreDeviceExecutionStatus(model.coreDeviceExecutionStatus);
            this.reason(model.reason);
            this.creationTimestamp(model.creationTimestamp);
            this.modifiedTimestamp(model.modifiedTimestamp);
            this.statusDetails(model.statusDetails);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getIotJobId() {
            return this.iotJobId;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final String getIotJobArn() {
            return this.iotJobArn;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getCoreDeviceExecutionStatus() {
            return this.coreDeviceExecutionStatus;
        }

        public final void setCoreDeviceExecutionStatus(String coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus = coreDeviceExecutionStatus;
        }

        @Override
        public final Builder coreDeviceExecutionStatus(String coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus = coreDeviceExecutionStatus;
            return this;
        }

        @Override
        public final Builder coreDeviceExecutionStatus(EffectiveDeploymentExecutionStatus coreDeviceExecutionStatus) {
            this.coreDeviceExecutionStatus(coreDeviceExecutionStatus == null ? null : coreDeviceExecutionStatus.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final EffectiveDeploymentStatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(EffectiveDeploymentStatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(EffectiveDeploymentStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public EffectiveDeployment build() {
            return new EffectiveDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EffectiveDeployment> {
        public Builder deploymentId(String var1);

        public Builder deploymentName(String var1);

        public Builder iotJobId(String var1);

        public Builder iotJobArn(String var1);

        public Builder description(String var1);

        public Builder targetArn(String var1);

        public Builder coreDeviceExecutionStatus(String var1);

        public Builder coreDeviceExecutionStatus(EffectiveDeploymentExecutionStatus var1);

        public Builder reason(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder modifiedTimestamp(Instant var1);

        public Builder statusDetails(EffectiveDeploymentStatusDetails var1);

        default public Builder statusDetails(Consumer<EffectiveDeploymentStatusDetails.Builder> statusDetails) {
            return this.statusDetails((EffectiveDeploymentStatusDetails)((EffectiveDeploymentStatusDetails.Builder)EffectiveDeploymentStatusDetails.builder().applyMutation(statusDetails)).build());
        }
    }
}

