/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.CloudComponentStatus;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentVersionResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, CreateComponentVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateComponentVersionResponse.getter(CreateComponentVersionResponse::arn)).setter(CreateComponentVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(CreateComponentVersionResponse.getter(CreateComponentVersionResponse::componentName)).setter(CreateComponentVersionResponse.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(CreateComponentVersionResponse.getter(CreateComponentVersionResponse::componentVersion)).setter(CreateComponentVersionResponse.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(CreateComponentVersionResponse.getter(CreateComponentVersionResponse::creationTimestamp)).setter(CreateComponentVersionResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<CloudComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(CreateComponentVersionResponse.getter(CreateComponentVersionResponse::status)).setter(CreateComponentVersionResponse.setter(Builder::status)).constructor(CloudComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, CREATION_TIMESTAMP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComponentVersionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String componentName;
    private final String componentVersion;
    private final Instant creationTimestamp;
    private final CloudComponentStatus status;

    private CreateComponentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.creationTimestamp = builder.creationTimestamp;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final CloudComponentStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentVersionResponse)) {
            return false;
        }
        CreateComponentVersionResponse other = (CreateComponentVersionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComponentVersionResponse").add("Arn", (Object)this.arn()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("componentVersion", COMPONENT_VERSION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentVersionResponse, T> g) {
        return obj -> g.apply((CreateComponentVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String arn;
        private String componentName;
        private String componentVersion;
        private Instant creationTimestamp;
        private CloudComponentStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentVersionResponse model) {
            super(model);
            this.arn(model.arn);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.creationTimestamp(model.creationTimestamp);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final CloudComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(CloudComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(CloudComponentStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateComponentVersionResponse build() {
            return new CreateComponentVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentVersionResponse> {
        public Builder arn(String var1);

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder status(CloudComponentStatus var1);

        default public Builder status(Consumer<CloudComponentStatus.Builder> status) {
            return this.status((CloudComponentStatus)((CloudComponentStatus.Builder)CloudComponentStatus.builder().applyMutation(status)).build());
        }
    }
}

