/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemResourceLimits
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemResourceLimits> {
    private static final SdkField<Long> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("memory").getter(SystemResourceLimits.getter(SystemResourceLimits::memory)).setter(SystemResourceLimits.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Double> CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("cpus").getter(SystemResourceLimits.getter(SystemResourceLimits::cpus)).setter(SystemResourceLimits.setter(Builder::cpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("memory", MEMORY_FIELD);
            this.put("cpus", CPUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long memory;
    private final Double cpus;

    private SystemResourceLimits(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpus = builder.cpus;
    }

    public final Long memory() {
        return this.memory;
    }

    public final Double cpus() {
        return this.cpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemResourceLimits)) {
            return false;
        }
        SystemResourceLimits other = (SystemResourceLimits)obj;
        return Objects.equals(this.memory(), other.memory()) && Objects.equals(this.cpus(), other.cpus());
    }

    public final String toString() {
        return ToString.builder((String)"SystemResourceLimits").add("Memory", (Object)this.memory()).add("Cpus", (Object)this.cpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "cpus": {
                return Optional.ofNullable(clazz.cast(this.cpus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SystemResourceLimits, T> g) {
        return obj -> g.apply((SystemResourceLimits)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long memory;
        private Double cpus;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemResourceLimits model) {
            this.memory(model.memory);
            this.cpus(model.cpus);
        }

        public final Long getMemory() {
            return this.memory;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final Double getCpus() {
            return this.cpus;
        }

        public final void setCpus(Double cpus) {
            this.cpus = cpus;
        }

        @Override
        public final Builder cpus(Double cpus) {
            this.cpus = cpus;
            return this;
        }

        public SystemResourceLimits build() {
            return new SystemResourceLimits(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemResourceLimits> {
        public Builder memory(Long var1);

        public Builder cpus(Double var1);
    }
}

