/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobAbortAction;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobExecutionFailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IoTJobAbortCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IoTJobAbortCriteria> {
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureType").getter(IoTJobAbortCriteria.getter(IoTJobAbortCriteria::failureTypeAsString)).setter(IoTJobAbortCriteria.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureType").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(IoTJobAbortCriteria.getter(IoTJobAbortCriteria::actionAsString)).setter(IoTJobAbortCriteria.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("thresholdPercentage").getter(IoTJobAbortCriteria.getter(IoTJobAbortCriteria::thresholdPercentage)).setter(IoTJobAbortCriteria.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdPercentage").build()}).build();
    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minNumberOfExecutedThings").getter(IoTJobAbortCriteria.getter(IoTJobAbortCriteria::minNumberOfExecutedThings)).setter(IoTJobAbortCriteria.setter(Builder::minNumberOfExecutedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minNumberOfExecutedThings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_TYPE_FIELD, ACTION_FIELD, THRESHOLD_PERCENTAGE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("failureType", FAILURE_TYPE_FIELD);
            this.put("action", ACTION_FIELD);
            this.put("thresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
            this.put("minNumberOfExecutedThings", MIN_NUMBER_OF_EXECUTED_THINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String failureType;
    private final String action;
    private final Double thresholdPercentage;
    private final Integer minNumberOfExecutedThings;

    private IoTJobAbortCriteria(BuilderImpl builder) {
        this.failureType = builder.failureType;
        this.action = builder.action;
        this.thresholdPercentage = builder.thresholdPercentage;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
    }

    public final IoTJobExecutionFailureType failureType() {
        return IoTJobExecutionFailureType.fromValue(this.failureType);
    }

    public final String failureTypeAsString() {
        return this.failureType;
    }

    public final IoTJobAbortAction action() {
        return IoTJobAbortAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final Double thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public final Integer minNumberOfExecutedThings() {
        return this.minNumberOfExecutedThings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.minNumberOfExecutedThings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IoTJobAbortCriteria)) {
            return false;
        }
        IoTJobAbortCriteria other = (IoTJobAbortCriteria)obj;
        return Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.thresholdPercentage(), other.thresholdPercentage()) && Objects.equals(this.minNumberOfExecutedThings(), other.minNumberOfExecutedThings());
    }

    public final String toString() {
        return ToString.builder((String)"IoTJobAbortCriteria").add("FailureType", (Object)this.failureTypeAsString()).add("Action", (Object)this.actionAsString()).add("ThresholdPercentage", (Object)this.thresholdPercentage()).add("MinNumberOfExecutedThings", (Object)this.minNumberOfExecutedThings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "thresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
            case "minNumberOfExecutedThings": {
                return Optional.ofNullable(clazz.cast(this.minNumberOfExecutedThings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IoTJobAbortCriteria, T> g) {
        return obj -> g.apply((IoTJobAbortCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureType;
        private String action;
        private Double thresholdPercentage;
        private Integer minNumberOfExecutedThings;

        private BuilderImpl() {
        }

        private BuilderImpl(IoTJobAbortCriteria model) {
            this.failureType(model.failureType);
            this.action(model.action);
            this.thresholdPercentage(model.thresholdPercentage);
            this.minNumberOfExecutedThings(model.minNumberOfExecutedThings);
        }

        public final String getFailureType() {
            return this.failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(IoTJobExecutionFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(IoTJobAbortAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Double getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return this.minNumberOfExecutedThings;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        @Override
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        public IoTJobAbortCriteria build() {
            return new IoTJobAbortCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IoTJobAbortCriteria> {
        public Builder failureType(String var1);

        public Builder failureType(IoTJobExecutionFailureType var1);

        public Builder action(String var1);

        public Builder action(IoTJobAbortAction var1);

        public Builder thresholdPercentage(Double var1);

        public Builder minNumberOfExecutedThings(Integer var1);
    }
}

