/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.CoreDeviceStatus;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoreDeviceResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, GetCoreDeviceResponse> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreDeviceThingName").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::coreDeviceThingName)).setter(GetCoreDeviceResponse.setter(Builder::coreDeviceThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build()}).build();
    private static final SdkField<String> CORE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreVersion").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::coreVersion)).setter(GetCoreDeviceResponse.setter(Builder::coreVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreVersion").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::platform)).setter(GetCoreDeviceResponse.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::architecture)).setter(GetCoreDeviceResponse.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::statusAsString)).setter(GetCoreDeviceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusUpdateTimestamp").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::lastStatusUpdateTimestamp)).setter(GetCoreDeviceResponse.setter(Builder::lastStatusUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusUpdateTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetCoreDeviceResponse.getter(GetCoreDeviceResponse::tags)).setter(GetCoreDeviceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD, CORE_VERSION_FIELD, PLATFORM_FIELD, ARCHITECTURE_FIELD, STATUS_FIELD, LAST_STATUS_UPDATE_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("coreDeviceThingName", CORE_DEVICE_THING_NAME_FIELD);
            this.put("coreVersion", CORE_VERSION_FIELD);
            this.put("platform", PLATFORM_FIELD);
            this.put("architecture", ARCHITECTURE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("lastStatusUpdateTimestamp", LAST_STATUS_UPDATE_TIMESTAMP_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String coreDeviceThingName;
    private final String coreVersion;
    private final String platform;
    private final String architecture;
    private final String status;
    private final Instant lastStatusUpdateTimestamp;
    private final Map<String, String> tags;

    private GetCoreDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.coreVersion = builder.coreVersion;
        this.platform = builder.platform;
        this.architecture = builder.architecture;
        this.status = builder.status;
        this.lastStatusUpdateTimestamp = builder.lastStatusUpdateTimestamp;
        this.tags = builder.tags;
    }

    public final String coreDeviceThingName() {
        return this.coreDeviceThingName;
    }

    public final String coreVersion() {
        return this.coreVersion;
    }

    public final String platform() {
        return this.platform;
    }

    public final String architecture() {
        return this.architecture;
    }

    public final CoreDeviceStatus status() {
        return CoreDeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastStatusUpdateTimestamp() {
        return this.lastStatusUpdateTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreDeviceResponse)) {
            return false;
        }
        GetCoreDeviceResponse other = (GetCoreDeviceResponse)((Object)obj);
        return Objects.equals(this.coreDeviceThingName(), other.coreDeviceThingName()) && Objects.equals(this.coreVersion(), other.coreVersion()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastStatusUpdateTimestamp(), other.lastStatusUpdateTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetCoreDeviceResponse").add("CoreDeviceThingName", (Object)this.coreDeviceThingName()).add("CoreVersion", (Object)this.coreVersion()).add("Platform", (Object)this.platform()).add("Architecture", (Object)this.architecture()).add("Status", (Object)this.statusAsString()).add("LastStatusUpdateTimestamp", (Object)this.lastStatusUpdateTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coreDeviceThingName": {
                return Optional.ofNullable(clazz.cast(this.coreDeviceThingName()));
            }
            case "coreVersion": {
                return Optional.ofNullable(clazz.cast(this.coreVersion()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastStatusUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastStatusUpdateTimestamp()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreDeviceResponse, T> g) {
        return obj -> g.apply((GetCoreDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String coreDeviceThingName;
        private String coreVersion;
        private String platform;
        private String architecture;
        private String status;
        private Instant lastStatusUpdateTimestamp;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreDeviceResponse model) {
            super(model);
            this.coreDeviceThingName(model.coreDeviceThingName);
            this.coreVersion(model.coreVersion);
            this.platform(model.platform);
            this.architecture(model.architecture);
            this.status(model.status);
            this.lastStatusUpdateTimestamp(model.lastStatusUpdateTimestamp);
            this.tags(model.tags);
        }

        public final String getCoreDeviceThingName() {
            return this.coreDeviceThingName;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final String getCoreVersion() {
            return this.coreVersion;
        }

        public final void setCoreVersion(String coreVersion) {
            this.coreVersion = coreVersion;
        }

        @Override
        public final Builder coreVersion(String coreVersion) {
            this.coreVersion = coreVersion;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CoreDeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastStatusUpdateTimestamp() {
            return this.lastStatusUpdateTimestamp;
        }

        public final void setLastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
        }

        @Override
        public final Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetCoreDeviceResponse build() {
            return new GetCoreDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoreDeviceResponse> {
        public Builder coreDeviceThingName(String var1);

        public Builder coreVersion(String var1);

        public Builder platform(String var1);

        public Builder architecture(String var1);

        public Builder status(String var1);

        public Builder status(CoreDeviceStatus var1);

        public Builder lastStatusUpdateTimestamp(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

