/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.services.greengrassv2.model.LambdaFunctionRecipeSource;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentVersionRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, CreateComponentVersionRequest> {
    private static final SdkField<SdkBytes> INLINE_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("inlineRecipe").getter(CreateComponentVersionRequest.getter(CreateComponentVersionRequest::inlineRecipe)).setter(CreateComponentVersionRequest.setter(Builder::inlineRecipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRecipe").build()}).build();
    private static final SdkField<LambdaFunctionRecipeSource> LAMBDA_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaFunction").getter(CreateComponentVersionRequest.getter(CreateComponentVersionRequest::lambdaFunction)).setter(CreateComponentVersionRequest.setter(Builder::lambdaFunction)).constructor(LambdaFunctionRecipeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateComponentVersionRequest.getter(CreateComponentVersionRequest::tags)).setter(CreateComponentVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateComponentVersionRequest.getter(CreateComponentVersionRequest::clientToken)).setter(CreateComponentVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_RECIPE_FIELD, LAMBDA_FUNCTION_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inlineRecipe", INLINE_RECIPE_FIELD);
            this.put("lambdaFunction", LAMBDA_FUNCTION_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final SdkBytes inlineRecipe;
    private final LambdaFunctionRecipeSource lambdaFunction;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateComponentVersionRequest(BuilderImpl builder) {
        super(builder);
        this.inlineRecipe = builder.inlineRecipe;
        this.lambdaFunction = builder.lambdaFunction;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final SdkBytes inlineRecipe() {
        return this.inlineRecipe;
    }

    public final LambdaFunctionRecipeSource lambdaFunction() {
        return this.lambdaFunction;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineRecipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentVersionRequest)) {
            return false;
        }
        CreateComponentVersionRequest other = (CreateComponentVersionRequest)((Object)obj);
        return Objects.equals(this.inlineRecipe(), other.inlineRecipe()) && Objects.equals(this.lambdaFunction(), other.lambdaFunction()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComponentVersionRequest").add("InlineRecipe", (Object)this.inlineRecipe()).add("LambdaFunction", (Object)this.lambdaFunction()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inlineRecipe": {
                return Optional.ofNullable(clazz.cast(this.inlineRecipe()));
            }
            case "lambdaFunction": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunction()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentVersionRequest, T> g) {
        return obj -> g.apply((CreateComponentVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private SdkBytes inlineRecipe;
        private LambdaFunctionRecipeSource lambdaFunction;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentVersionRequest model) {
            super(model);
            this.inlineRecipe(model.inlineRecipe);
            this.lambdaFunction(model.lambdaFunction);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final ByteBuffer getInlineRecipe() {
            return this.inlineRecipe == null ? null : this.inlineRecipe.asByteBuffer();
        }

        public final void setInlineRecipe(ByteBuffer inlineRecipe) {
            this.inlineRecipe(inlineRecipe == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)inlineRecipe));
        }

        @Override
        public final Builder inlineRecipe(SdkBytes inlineRecipe) {
            this.inlineRecipe = inlineRecipe;
            return this;
        }

        public final LambdaFunctionRecipeSource.Builder getLambdaFunction() {
            return this.lambdaFunction != null ? this.lambdaFunction.toBuilder() : null;
        }

        public final void setLambdaFunction(LambdaFunctionRecipeSource.BuilderImpl lambdaFunction) {
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
        }

        @Override
        public final Builder lambdaFunction(LambdaFunctionRecipeSource lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComponentVersionRequest build() {
            return new CreateComponentVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentVersionRequest> {
        public Builder inlineRecipe(SdkBytes var1);

        public Builder lambdaFunction(LambdaFunctionRecipeSource var1);

        default public Builder lambdaFunction(Consumer<LambdaFunctionRecipeSource.Builder> lambdaFunction) {
            return this.lambdaFunction((LambdaFunctionRecipeSource)((LambdaFunctionRecipeSource.Builder)LambdaFunctionRecipeSource.builder().applyMutation(lambdaFunction)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

