/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.ComponentVersionListItem;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListComponentVersionsResponse;

public class ListComponentVersionsPublisher
implements SdkPublisher<ListComponentVersionsResponse> {
    private final GreengrassV2AsyncClient client;
    private final ListComponentVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComponentVersionsPublisher(GreengrassV2AsyncClient client, ListComponentVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComponentVersionsPublisher(GreengrassV2AsyncClient client, ListComponentVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComponentVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComponentVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComponentVersionListItem> componentVersions() {
        Function<ListComponentVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.componentVersions() != null) {
                return response.componentVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComponentVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComponentVersionsResponseFetcher
    implements AsyncPageFetcher<ListComponentVersionsResponse> {
        private ListComponentVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListComponentVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComponentVersionsResponse> nextPage(ListComponentVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListComponentVersionsPublisher.this.client.listComponentVersions(ListComponentVersionsPublisher.this.firstRequest);
            }
            return ListComponentVersionsPublisher.this.client.listComponentVersions((ListComponentVersionsRequest)((Object)ListComponentVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

