/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDependencyMapCopier;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDependencyRequirement;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatformListCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaExecutionParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaFunctionRecipeSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaFunctionRecipeSource> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaArn").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::lambdaArn)).setter(LambdaFunctionRecipeSource.setter(Builder::lambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaArn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::componentName)).setter(LambdaFunctionRecipeSource.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::componentVersion)).setter(LambdaFunctionRecipeSource.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<List<ComponentPlatform>> COMPONENT_PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentPlatforms").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::componentPlatforms)).setter(LambdaFunctionRecipeSource.setter(Builder::componentPlatforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentPlatforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentDependencyRequirement>> COMPONENT_DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("componentDependencies").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::componentDependencies)).setter(LambdaFunctionRecipeSource.setter(Builder::componentDependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentDependencies").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentDependencyRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LambdaExecutionParameters> COMPONENT_LAMBDA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("componentLambdaParameters").getter(LambdaFunctionRecipeSource.getter(LambdaFunctionRecipeSource::componentLambdaParameters)).setter(LambdaFunctionRecipeSource.setter(Builder::componentLambdaParameters)).constructor(LambdaExecutionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentLambdaParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, COMPONENT_PLATFORMS_FIELD, COMPONENT_DEPENDENCIES_FIELD, COMPONENT_LAMBDA_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lambdaArn;
    private final String componentName;
    private final String componentVersion;
    private final List<ComponentPlatform> componentPlatforms;
    private final Map<String, ComponentDependencyRequirement> componentDependencies;
    private final LambdaExecutionParameters componentLambdaParameters;

    private LambdaFunctionRecipeSource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.componentPlatforms = builder.componentPlatforms;
        this.componentDependencies = builder.componentDependencies;
        this.componentLambdaParameters = builder.componentLambdaParameters;
    }

    public final String lambdaArn() {
        return this.lambdaArn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final boolean hasComponentPlatforms() {
        return this.componentPlatforms != null && !(this.componentPlatforms instanceof SdkAutoConstructList);
    }

    public final List<ComponentPlatform> componentPlatforms() {
        return this.componentPlatforms;
    }

    public final boolean hasComponentDependencies() {
        return this.componentDependencies != null && !(this.componentDependencies instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentDependencyRequirement> componentDependencies() {
        return this.componentDependencies;
    }

    public final LambdaExecutionParameters componentLambdaParameters() {
        return this.componentLambdaParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentPlatforms() ? this.componentPlatforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentDependencies() ? this.componentDependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.componentLambdaParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionRecipeSource)) {
            return false;
        }
        LambdaFunctionRecipeSource other = (LambdaFunctionRecipeSource)obj;
        return Objects.equals(this.lambdaArn(), other.lambdaArn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && this.hasComponentPlatforms() == other.hasComponentPlatforms() && Objects.equals(this.componentPlatforms(), other.componentPlatforms()) && this.hasComponentDependencies() == other.hasComponentDependencies() && Objects.equals(this.componentDependencies(), other.componentDependencies()) && Objects.equals(this.componentLambdaParameters(), other.componentLambdaParameters());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaFunctionRecipeSource").add("LambdaArn", (Object)this.lambdaArn()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("ComponentPlatforms", this.hasComponentPlatforms() ? this.componentPlatforms() : null).add("ComponentDependencies", this.hasComponentDependencies() ? this.componentDependencies() : null).add("ComponentLambdaParameters", (Object)this.componentLambdaParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "componentPlatforms": {
                return Optional.ofNullable(clazz.cast(this.componentPlatforms()));
            }
            case "componentDependencies": {
                return Optional.ofNullable(clazz.cast(this.componentDependencies()));
            }
            case "componentLambdaParameters": {
                return Optional.ofNullable(clazz.cast(this.componentLambdaParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionRecipeSource, T> g) {
        return obj -> g.apply((LambdaFunctionRecipeSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaArn;
        private String componentName;
        private String componentVersion;
        private List<ComponentPlatform> componentPlatforms = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ComponentDependencyRequirement> componentDependencies = DefaultSdkAutoConstructMap.getInstance();
        private LambdaExecutionParameters componentLambdaParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionRecipeSource model) {
            this.lambdaArn(model.lambdaArn);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.componentPlatforms(model.componentPlatforms);
            this.componentDependencies(model.componentDependencies);
            this.componentLambdaParameters(model.componentLambdaParameters);
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final List<ComponentPlatform.Builder> getComponentPlatforms() {
            List<ComponentPlatform.Builder> result = ComponentPlatformListCopier.copyToBuilder(this.componentPlatforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentPlatforms(Collection<ComponentPlatform.BuilderImpl> componentPlatforms) {
            this.componentPlatforms = ComponentPlatformListCopier.copyFromBuilder(componentPlatforms);
        }

        @Override
        public final Builder componentPlatforms(Collection<ComponentPlatform> componentPlatforms) {
            this.componentPlatforms = ComponentPlatformListCopier.copy(componentPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentPlatforms(ComponentPlatform ... componentPlatforms) {
            this.componentPlatforms(Arrays.asList(componentPlatforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentPlatforms(Consumer<ComponentPlatform.Builder> ... componentPlatforms) {
            this.componentPlatforms(Stream.of(componentPlatforms).map(c -> (ComponentPlatform)((ComponentPlatform.Builder)ComponentPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ComponentDependencyRequirement.Builder> getComponentDependencies() {
            Map<String, ComponentDependencyRequirement.Builder> result = ComponentDependencyMapCopier.copyToBuilder(this.componentDependencies);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponentDependencies(Map<String, ComponentDependencyRequirement.BuilderImpl> componentDependencies) {
            this.componentDependencies = ComponentDependencyMapCopier.copyFromBuilder(componentDependencies);
        }

        @Override
        public final Builder componentDependencies(Map<String, ComponentDependencyRequirement> componentDependencies) {
            this.componentDependencies = ComponentDependencyMapCopier.copy(componentDependencies);
            return this;
        }

        public final LambdaExecutionParameters.Builder getComponentLambdaParameters() {
            return this.componentLambdaParameters != null ? this.componentLambdaParameters.toBuilder() : null;
        }

        public final void setComponentLambdaParameters(LambdaExecutionParameters.BuilderImpl componentLambdaParameters) {
            this.componentLambdaParameters = componentLambdaParameters != null ? componentLambdaParameters.build() : null;
        }

        @Override
        public final Builder componentLambdaParameters(LambdaExecutionParameters componentLambdaParameters) {
            this.componentLambdaParameters = componentLambdaParameters;
            return this;
        }

        public LambdaFunctionRecipeSource build() {
            return new LambdaFunctionRecipeSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaFunctionRecipeSource> {
        public Builder lambdaArn(String var1);

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder componentPlatforms(Collection<ComponentPlatform> var1);

        public Builder componentPlatforms(ComponentPlatform ... var1);

        public Builder componentPlatforms(Consumer<ComponentPlatform.Builder> ... var1);

        public Builder componentDependencies(Map<String, ComponentDependencyRequirement> var1);

        public Builder componentLambdaParameters(LambdaExecutionParameters var1);

        default public Builder componentLambdaParameters(Consumer<LambdaExecutionParameters.Builder> componentLambdaParameters) {
            return this.componentLambdaParameters((LambdaExecutionParameters)((LambdaExecutionParameters.Builder)LambdaExecutionParameters.builder().applyMutation(componentLambdaParameters)).build());
        }
    }
}

