/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3EndpointType {
    REGIONAL("REGIONAL"),
    GLOBAL("GLOBAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3EndpointType> VALUE_MAP;
    private final String value;

    private S3EndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3EndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3EndpointType> knownValues() {
        EnumSet<S3EndpointType> knownValues = EnumSet.allOf(S3EndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3EndpointType.class, S3EndpointType::toString);
    }
}

