/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2Client;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.CoreDevice;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListCoreDevicesResponse;

public class ListCoreDevicesIterable
implements SdkIterable<ListCoreDevicesResponse> {
    private final GreengrassV2Client client;
    private final ListCoreDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoreDevicesIterable(GreengrassV2Client client, ListCoreDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoreDevicesResponseFetcher();
    }

    public Iterator<ListCoreDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreDevice> coreDevices() {
        Function<ListCoreDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreDevices() != null) {
                return response.coreDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoreDevicesResponseFetcher
    implements SyncPageFetcher<ListCoreDevicesResponse> {
        private ListCoreDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoreDevicesResponse nextPage(ListCoreDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListCoreDevicesIterable.this.client.listCoreDevices(ListCoreDevicesIterable.this.firstRequest);
            }
            return ListCoreDevicesIterable.this.client.listCoreDevices((ListCoreDevicesRequest)((Object)ListCoreDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

