/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2;

import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrassv2.auth.scheme.GreengrassV2AuthSchemeProvider;
import software.amazon.awssdk.services.greengrassv2.internal.GreengrassV2ServiceClientConfigurationBuilder;

@SdkPublicApi
public final class GreengrassV2ServiceClientConfiguration
extends AwsServiceClientConfiguration {
    private final GreengrassV2AuthSchemeProvider authSchemeProvider;

    public GreengrassV2ServiceClientConfiguration(Builder builder) {
        super((AwsServiceClientConfiguration.Builder)builder);
        this.authSchemeProvider = builder.authSchemeProvider();
    }

    public GreengrassV2AuthSchemeProvider authSchemeProvider() {
        return this.authSchemeProvider;
    }

    public static Builder builder() {
        return GreengrassV2ServiceClientConfigurationBuilder.builder();
    }

    public static interface Builder
    extends AwsServiceClientConfiguration.Builder {
        public Builder overrideConfiguration(ClientOverrideConfiguration var1);

        public ClientOverrideConfiguration overrideConfiguration();

        public Builder endpointOverride(URI var1);

        public URI endpointOverride();

        public Builder endpointProvider(EndpointProvider var1);

        public EndpointProvider endpointProvider();

        public Builder region(Region var1);

        public Region region();

        public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> var1);

        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider();

        public Builder putAuthScheme(AuthScheme<?> var1);

        public Map<String, AuthScheme<?>> authSchemes();

        public Builder authSchemeProvider(GreengrassV2AuthSchemeProvider var1);

        public GreengrassV2AuthSchemeProvider authSchemeProvider();

        public GreengrassV2ServiceClientConfiguration build();
    }
}

