/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrassv2.DefaultGreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.DefaultGreengrassV2BaseClientBuilder;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClientBuilder;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2ServiceClientConfiguration;
import software.amazon.awssdk.services.greengrassv2.endpoints.GreengrassV2EndpointProvider;

@SdkInternalApi
final class DefaultGreengrassV2AsyncClientBuilder
extends DefaultGreengrassV2BaseClientBuilder<GreengrassV2AsyncClientBuilder, GreengrassV2AsyncClient>
implements GreengrassV2AsyncClientBuilder {
    DefaultGreengrassV2AsyncClientBuilder() {
    }

    @Override
    public DefaultGreengrassV2AsyncClientBuilder endpointProvider(GreengrassV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGreengrassV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        GreengrassV2ServiceClientConfiguration serviceClientConfiguration = GreengrassV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultGreengrassV2AsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

