/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2Client;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeployment;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse;

public class ListEffectiveDeploymentsIterable
implements SdkIterable<ListEffectiveDeploymentsResponse> {
    private final GreengrassV2Client client;
    private final ListEffectiveDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEffectiveDeploymentsIterable(GreengrassV2Client client, ListEffectiveDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEffectiveDeploymentsResponseFetcher();
    }

    public Iterator<ListEffectiveDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EffectiveDeployment> effectiveDeployments() {
        Function<ListEffectiveDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectiveDeployments() != null) {
                return response.effectiveDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEffectiveDeploymentsResponseFetcher
    implements SyncPageFetcher<ListEffectiveDeploymentsResponse> {
        private ListEffectiveDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEffectiveDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEffectiveDeploymentsResponse nextPage(ListEffectiveDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListEffectiveDeploymentsIterable.this.client.listEffectiveDeployments(ListEffectiveDeploymentsIterable.this.firstRequest);
            }
            return ListEffectiveDeploymentsIterable.this.client.listEffectiveDeployments((ListEffectiveDeploymentsRequest)((Object)ListEffectiveDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

