/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstalledComponentLifecycleState {
    NEW("NEW"),
    INSTALLED("INSTALLED"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    ERRORED("ERRORED"),
    BROKEN("BROKEN"),
    FINISHED("FINISHED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstalledComponentLifecycleState> VALUE_MAP;
    private final String value;

    private InstalledComponentLifecycleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstalledComponentLifecycleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstalledComponentLifecycleState> knownValues() {
        EnumSet<InstalledComponentLifecycleState> knownValues = EnumSet.allOf(InstalledComponentLifecycleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstalledComponentLifecycleState.class, InstalledComponentLifecycleState::toString);
    }
}

