/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2Client;
import software.amazon.awssdk.services.greengrassv2.model.InstalledComponent;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListInstalledComponentsResponse;

public class ListInstalledComponentsIterable
implements SdkIterable<ListInstalledComponentsResponse> {
    private final GreengrassV2Client client;
    private final ListInstalledComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstalledComponentsIterable(GreengrassV2Client client, ListInstalledComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstalledComponentsResponseFetcher();
    }

    public Iterator<ListInstalledComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstalledComponent> installedComponents() {
        Function<ListInstalledComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.installedComponents() != null) {
                return response.installedComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstalledComponentsResponseFetcher
    implements SyncPageFetcher<ListInstalledComponentsResponse> {
        private ListInstalledComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstalledComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstalledComponentsResponse nextPage(ListInstalledComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListInstalledComponentsIterable.this.client.listInstalledComponents(ListInstalledComponentsIterable.this.firstRequest);
            }
            return ListInstalledComponentsIterable.this.client.listInstalledComponents((ListInstalledComponentsRequest)((Object)ListInstalledComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

