/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComponentDependencyType {
    HARD("HARD"),
    SOFT("SOFT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComponentDependencyType> VALUE_MAP;
    private final String value;

    private ComponentDependencyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentDependencyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentDependencyType> knownValues() {
        EnumSet<ComponentDependencyType> knownValues = EnumSet.allOf(ComponentDependencyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComponentDependencyType.class, ComponentDependencyType::toString);
    }
}

