/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, CreateDeploymentResponse> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::deploymentId)).setter(CreateDeploymentResponse.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobId").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::iotJobId)).setter(CreateDeploymentResponse.setter(Builder::iotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()}).build();
    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobArn").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::iotJobArn)).setter(CreateDeploymentResponse.setter(Builder::iotJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, IOT_JOB_ID_FIELD, IOT_JOB_ARN_FIELD));
    private final String deploymentId;
    private final String iotJobId;
    private final String iotJobArn;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String iotJobId() {
        return this.iotJobId;
    }

    public final String iotJobArn() {
        return this.iotJobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.iotJobId(), other.iotJobId()) && Objects.equals(this.iotJobArn(), other.iotJobArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentResponse").add("DeploymentId", (Object)this.deploymentId()).add("IotJobId", (Object)this.iotJobId()).add("IotJobArn", (Object)this.iotJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "iotJobId": {
                return Optional.ofNullable(clazz.cast(this.iotJobId()));
            }
            case "iotJobArn": {
                return Optional.ofNullable(clazz.cast(this.iotJobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String iotJobId;
        private String iotJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.iotJobId(model.iotJobId);
            this.iotJobArn(model.iotJobArn);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        @Transient
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getIotJobId() {
            return this.iotJobId;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        @Override
        @Transient
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final String getIotJobArn() {
            return this.iotJobArn;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        @Override
        @Transient
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentResponse> {
        public Builder deploymentId(String var1);

        public Builder iotJobId(String var1);

        public Builder iotJobArn(String var1);
    }
}

