/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.ComponentConfigurationUpdate;
import software.amazon.awssdk.services.greengrassv2.model.ComponentRunWith;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentDeploymentSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentDeploymentSpecification> {
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ComponentDeploymentSpecification.getter(ComponentDeploymentSpecification::componentVersion)).setter(ComponentDeploymentSpecification.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<ComponentConfigurationUpdate> CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationUpdate").getter(ComponentDeploymentSpecification.getter(ComponentDeploymentSpecification::configurationUpdate)).setter(ComponentDeploymentSpecification.setter(Builder::configurationUpdate)).constructor(ComponentConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationUpdate").build()}).build();
    private static final SdkField<ComponentRunWith> RUN_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runWith").getter(ComponentDeploymentSpecification.getter(ComponentDeploymentSpecification::runWith)).setter(ComponentDeploymentSpecification.setter(Builder::runWith)).constructor(ComponentRunWith::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runWith").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_VERSION_FIELD, CONFIGURATION_UPDATE_FIELD, RUN_WITH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentVersion;
    private final ComponentConfigurationUpdate configurationUpdate;
    private final ComponentRunWith runWith;

    private ComponentDeploymentSpecification(BuilderImpl builder) {
        this.componentVersion = builder.componentVersion;
        this.configurationUpdate = builder.configurationUpdate;
        this.runWith = builder.runWith;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final ComponentConfigurationUpdate configurationUpdate() {
        return this.configurationUpdate;
    }

    public final ComponentRunWith runWith() {
        return this.runWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.runWith());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentDeploymentSpecification)) {
            return false;
        }
        ComponentDeploymentSpecification other = (ComponentDeploymentSpecification)obj;
        return Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.configurationUpdate(), other.configurationUpdate()) && Objects.equals(this.runWith(), other.runWith());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentDeploymentSpecification").add("ComponentVersion", (Object)this.componentVersion()).add("ConfigurationUpdate", (Object)this.configurationUpdate()).add("RunWith", (Object)this.runWith()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "configurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.configurationUpdate()));
            }
            case "runWith": {
                return Optional.ofNullable(clazz.cast(this.runWith()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentDeploymentSpecification, T> g) {
        return obj -> g.apply((ComponentDeploymentSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentVersion;
        private ComponentConfigurationUpdate configurationUpdate;
        private ComponentRunWith runWith;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentDeploymentSpecification model) {
            this.componentVersion(model.componentVersion);
            this.configurationUpdate(model.configurationUpdate);
            this.runWith(model.runWith);
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final ComponentConfigurationUpdate.Builder getConfigurationUpdate() {
            return this.configurationUpdate != null ? this.configurationUpdate.toBuilder() : null;
        }

        public final void setConfigurationUpdate(ComponentConfigurationUpdate.BuilderImpl configurationUpdate) {
            this.configurationUpdate = configurationUpdate != null ? configurationUpdate.build() : null;
        }

        @Override
        public final Builder configurationUpdate(ComponentConfigurationUpdate configurationUpdate) {
            this.configurationUpdate = configurationUpdate;
            return this;
        }

        public final ComponentRunWith.Builder getRunWith() {
            return this.runWith != null ? this.runWith.toBuilder() : null;
        }

        public final void setRunWith(ComponentRunWith.BuilderImpl runWith) {
            this.runWith = runWith != null ? runWith.build() : null;
        }

        @Override
        public final Builder runWith(ComponentRunWith runWith) {
            this.runWith = runWith;
            return this;
        }

        public ComponentDeploymentSpecification build() {
            return new ComponentDeploymentSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentDeploymentSpecification> {
        public Builder componentVersion(String var1);

        public Builder configurationUpdate(ComponentConfigurationUpdate var1);

        default public Builder configurationUpdate(Consumer<ComponentConfigurationUpdate.Builder> configurationUpdate) {
            return this.configurationUpdate((ComponentConfigurationUpdate)((ComponentConfigurationUpdate.Builder)ComponentConfigurationUpdate.builder().applyMutation(configurationUpdate)).build());
        }

        public Builder runWith(ComponentRunWith var1);

        default public Builder runWith(Consumer<ComponentRunWith.Builder> runWith) {
            return this.runWith((ComponentRunWith)((ComponentRunWith.Builder)ComponentRunWith.builder().applyMutation(runWith)).build());
        }
    }
}

