/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.ComponentVersionRequirementMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentCandidate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentCandidate> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentCandidate.getter(ComponentCandidate::componentName)).setter(ComponentCandidate.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ComponentCandidate.getter(ComponentCandidate::componentVersion)).setter(ComponentCandidate.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<Map<String, String>> VERSION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("versionRequirements").getter(ComponentCandidate.getter(ComponentCandidate::versionRequirements)).setter(ComponentCandidate.setter(Builder::versionRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRequirements").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, VERSION_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String componentVersion;
    private final Map<String, String> versionRequirements;

    private ComponentCandidate(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.versionRequirements = builder.versionRequirements;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final boolean hasVersionRequirements() {
        return this.versionRequirements != null && !(this.versionRequirements instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> versionRequirements() {
        return this.versionRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionRequirements() ? this.versionRequirements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentCandidate)) {
            return false;
        }
        ComponentCandidate other = (ComponentCandidate)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && this.hasVersionRequirements() == other.hasVersionRequirements() && Objects.equals(this.versionRequirements(), other.versionRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentCandidate").add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("VersionRequirements", this.hasVersionRequirements() ? this.versionRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "versionRequirements": {
                return Optional.ofNullable(clazz.cast(this.versionRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentCandidate, T> g) {
        return obj -> g.apply((ComponentCandidate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String componentVersion;
        private Map<String, String> versionRequirements = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentCandidate model) {
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.versionRequirements(model.versionRequirements);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        @Transient
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        @Override
        @Transient
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final Map<String, String> getVersionRequirements() {
            if (this.versionRequirements instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.versionRequirements;
        }

        public final void setVersionRequirements(Map<String, String> versionRequirements) {
            this.versionRequirements = ComponentVersionRequirementMapCopier.copy(versionRequirements);
        }

        @Override
        @Transient
        public final Builder versionRequirements(Map<String, String> versionRequirements) {
            this.versionRequirements = ComponentVersionRequirementMapCopier.copy(versionRequirements);
            return this;
        }

        public ComponentCandidate build() {
            return new ComponentCandidate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentCandidate> {
        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder versionRequirements(Map<String, String> var1);
    }
}

