/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.ConnectivityInfo;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.services.greengrassv2.model._connectivityInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectivityInfoRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingName").getter(UpdateConnectivityInfoRequest.getter(UpdateConnectivityInfoRequest::thingName)).setter(UpdateConnectivityInfoRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<List<ConnectivityInfo>> CONNECTIVITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectivityInfo").getter(UpdateConnectivityInfoRequest.getter(UpdateConnectivityInfoRequest::connectivityInfo)).setter(UpdateConnectivityInfoRequest.setter(Builder::connectivityInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectivityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, CONNECTIVITY_INFO_FIELD));
    private final String thingName;
    private final List<ConnectivityInfo> connectivityInfo;

    private UpdateConnectivityInfoRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.connectivityInfo = builder.connectivityInfo;
    }

    public final String thingName() {
        return this.thingName;
    }

    public final boolean hasConnectivityInfo() {
        return this.connectivityInfo != null && !(this.connectivityInfo instanceof SdkAutoConstructList);
    }

    public final List<ConnectivityInfo> connectivityInfo() {
        return this.connectivityInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectivityInfo() ? this.connectivityInfo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityInfoRequest)) {
            return false;
        }
        UpdateConnectivityInfoRequest other = (UpdateConnectivityInfoRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && this.hasConnectivityInfo() == other.hasConnectivityInfo() && Objects.equals(this.connectivityInfo(), other.connectivityInfo());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectivityInfoRequest").add("ThingName", (Object)this.thingName()).add("ConnectivityInfo", this.hasConnectivityInfo() ? this.connectivityInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "connectivityInfo": {
                return Optional.ofNullable(clazz.cast(this.connectivityInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectivityInfoRequest, T> g) {
        return obj -> g.apply((UpdateConnectivityInfoRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private String thingName;
        private List<ConnectivityInfo> connectivityInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityInfoRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.connectivityInfo(model.connectivityInfo);
        }

        public final String getThingName() {
            return this.thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final List<ConnectivityInfo.Builder> getConnectivityInfo() {
            List<ConnectivityInfo.Builder> result = _connectivityInfoListCopier.copyToBuilder(this.connectivityInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo.BuilderImpl> connectivityInfo) {
            this.connectivityInfo = _connectivityInfoListCopier.copyFromBuilder(connectivityInfo);
        }

        @Override
        @Transient
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = _connectivityInfoListCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo ... connectivityInfo) {
            this.connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> ... connectivityInfo) {
            this.connectivityInfo(Stream.of(connectivityInfo).map(c -> (ConnectivityInfo)((ConnectivityInfo.Builder)ConnectivityInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectivityInfoRequest build() {
            return new UpdateConnectivityInfoRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
        public Builder thingName(String var1);

        public Builder connectivityInfo(Collection<ConnectivityInfo> var1);

        public Builder connectivityInfo(ConnectivityInfo ... var1);

        public Builder connectivityInfo(Consumer<ConnectivityInfo.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

