/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CoreDeviceStatus {
    HEALTHY("HEALTHY"),
    UNHEALTHY("UNHEALTHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CoreDeviceStatus> VALUE_MAP;
    private final String value;

    private CoreDeviceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CoreDeviceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CoreDeviceStatus> knownValues() {
        EnumSet<CoreDeviceStatus> knownValues = EnumSet.allOf(CoreDeviceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CoreDeviceStatus.class, CoreDeviceStatus::toString);
    }
}

