/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentStatus {
    ACTIVE("ACTIVE"),
    COMPLETED("COMPLETED"),
    CANCELED("CANCELED"),
    FAILED("FAILED"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentStatus> VALUE_MAP;
    private final String value;

    private DeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentStatus> knownValues() {
        EnumSet<DeploymentStatus> knownValues = EnumSet.allOf(DeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentStatus.class, DeploymentStatus::toString);
    }
}

