/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedComponentVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedComponentVersion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::arn)).setter(ResolvedComponentVersion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::componentName)).setter(ResolvedComponentVersion.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> COMPONENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentVersion").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::componentVersion)).setter(ResolvedComponentVersion.setter(Builder::componentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentVersion").build()}).build();
    private static final SdkField<SdkBytes> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("recipe").getter(ResolvedComponentVersion.getter(ResolvedComponentVersion::recipe)).setter(ResolvedComponentVersion.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPONENT_NAME_FIELD, COMPONENT_VERSION_FIELD, RECIPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String componentName;
    private final String componentVersion;
    private final SdkBytes recipe;

    private ResolvedComponentVersion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.recipe = builder.recipe;
    }

    public final String arn() {
        return this.arn;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String componentVersion() {
        return this.componentVersion;
    }

    public final SdkBytes recipe() {
        return this.recipe;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedComponentVersion)) {
            return false;
        }
        ResolvedComponentVersion other = (ResolvedComponentVersion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.componentVersion(), other.componentVersion()) && Objects.equals(this.recipe(), other.recipe());
    }

    public final String toString() {
        return ToString.builder((String)"ResolvedComponentVersion").add("Arn", (Object)this.arn()).add("ComponentName", (Object)this.componentName()).add("ComponentVersion", (Object)this.componentVersion()).add("Recipe", (Object)this.recipe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "componentVersion": {
                return Optional.ofNullable(clazz.cast(this.componentVersion()));
            }
            case "recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedComponentVersion, T> g) {
        return obj -> g.apply((ResolvedComponentVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String componentName;
        private String componentVersion;
        private SdkBytes recipe;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedComponentVersion model) {
            this.arn(model.arn);
            this.componentName(model.componentName);
            this.componentVersion(model.componentVersion);
            this.recipe(model.recipe);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final String getComponentVersion() {
            return this.componentVersion;
        }

        @Override
        public final Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public final void setComponentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
        }

        public final ByteBuffer getRecipe() {
            return this.recipe == null ? null : this.recipe.asByteBuffer();
        }

        @Override
        public final Builder recipe(SdkBytes recipe) {
            this.recipe = recipe;
            return this;
        }

        public final void setRecipe(ByteBuffer recipe) {
            this.recipe(recipe == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)recipe));
        }

        public ResolvedComponentVersion build() {
            return new ResolvedComponentVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedComponentVersion> {
        public Builder arn(String var1);

        public Builder componentName(String var1);

        public Builder componentVersion(String var1);

        public Builder recipe(SdkBytes var1);
    }
}

