/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentComponentUpdatePolicy;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentConfigurationValidationPolicy;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentFailureHandlingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentPolicies
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentPolicies> {
    private static final SdkField<String> FAILURE_HANDLING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureHandlingPolicy").getter(DeploymentPolicies.getter(DeploymentPolicies::failureHandlingPolicyAsString)).setter(DeploymentPolicies.setter(Builder::failureHandlingPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureHandlingPolicy").build()}).build();
    private static final SdkField<DeploymentComponentUpdatePolicy> COMPONENT_UPDATE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("componentUpdatePolicy").getter(DeploymentPolicies.getter(DeploymentPolicies::componentUpdatePolicy)).setter(DeploymentPolicies.setter(Builder::componentUpdatePolicy)).constructor(DeploymentComponentUpdatePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentUpdatePolicy").build()}).build();
    private static final SdkField<DeploymentConfigurationValidationPolicy> CONFIGURATION_VALIDATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationValidationPolicy").getter(DeploymentPolicies.getter(DeploymentPolicies::configurationValidationPolicy)).setter(DeploymentPolicies.setter(Builder::configurationValidationPolicy)).constructor(DeploymentConfigurationValidationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationValidationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_HANDLING_POLICY_FIELD, COMPONENT_UPDATE_POLICY_FIELD, CONFIGURATION_VALIDATION_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String failureHandlingPolicy;
    private final DeploymentComponentUpdatePolicy componentUpdatePolicy;
    private final DeploymentConfigurationValidationPolicy configurationValidationPolicy;

    private DeploymentPolicies(BuilderImpl builder) {
        this.failureHandlingPolicy = builder.failureHandlingPolicy;
        this.componentUpdatePolicy = builder.componentUpdatePolicy;
        this.configurationValidationPolicy = builder.configurationValidationPolicy;
    }

    public final DeploymentFailureHandlingPolicy failureHandlingPolicy() {
        return DeploymentFailureHandlingPolicy.fromValue(this.failureHandlingPolicy);
    }

    public final String failureHandlingPolicyAsString() {
        return this.failureHandlingPolicy;
    }

    public final DeploymentComponentUpdatePolicy componentUpdatePolicy() {
        return this.componentUpdatePolicy;
    }

    public final DeploymentConfigurationValidationPolicy configurationValidationPolicy() {
        return this.configurationValidationPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureHandlingPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationValidationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentPolicies)) {
            return false;
        }
        DeploymentPolicies other = (DeploymentPolicies)obj;
        return Objects.equals(this.failureHandlingPolicyAsString(), other.failureHandlingPolicyAsString()) && Objects.equals(this.componentUpdatePolicy(), other.componentUpdatePolicy()) && Objects.equals(this.configurationValidationPolicy(), other.configurationValidationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentPolicies").add("FailureHandlingPolicy", (Object)this.failureHandlingPolicyAsString()).add("ComponentUpdatePolicy", (Object)this.componentUpdatePolicy()).add("ConfigurationValidationPolicy", (Object)this.configurationValidationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureHandlingPolicy": {
                return Optional.ofNullable(clazz.cast(this.failureHandlingPolicyAsString()));
            }
            case "componentUpdatePolicy": {
                return Optional.ofNullable(clazz.cast(this.componentUpdatePolicy()));
            }
            case "configurationValidationPolicy": {
                return Optional.ofNullable(clazz.cast(this.configurationValidationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentPolicies, T> g) {
        return obj -> g.apply((DeploymentPolicies)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureHandlingPolicy;
        private DeploymentComponentUpdatePolicy componentUpdatePolicy;
        private DeploymentConfigurationValidationPolicy configurationValidationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentPolicies model) {
            this.failureHandlingPolicy(model.failureHandlingPolicy);
            this.componentUpdatePolicy(model.componentUpdatePolicy);
            this.configurationValidationPolicy(model.configurationValidationPolicy);
        }

        public final String getFailureHandlingPolicy() {
            return this.failureHandlingPolicy;
        }

        @Override
        public final Builder failureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
            return this;
        }

        @Override
        public final Builder failureHandlingPolicy(DeploymentFailureHandlingPolicy failureHandlingPolicy) {
            this.failureHandlingPolicy(failureHandlingPolicy == null ? null : failureHandlingPolicy.toString());
            return this;
        }

        public final void setFailureHandlingPolicy(String failureHandlingPolicy) {
            this.failureHandlingPolicy = failureHandlingPolicy;
        }

        public final DeploymentComponentUpdatePolicy.Builder getComponentUpdatePolicy() {
            return this.componentUpdatePolicy != null ? this.componentUpdatePolicy.toBuilder() : null;
        }

        @Override
        public final Builder componentUpdatePolicy(DeploymentComponentUpdatePolicy componentUpdatePolicy) {
            this.componentUpdatePolicy = componentUpdatePolicy;
            return this;
        }

        public final void setComponentUpdatePolicy(DeploymentComponentUpdatePolicy.BuilderImpl componentUpdatePolicy) {
            this.componentUpdatePolicy = componentUpdatePolicy != null ? componentUpdatePolicy.build() : null;
        }

        public final DeploymentConfigurationValidationPolicy.Builder getConfigurationValidationPolicy() {
            return this.configurationValidationPolicy != null ? this.configurationValidationPolicy.toBuilder() : null;
        }

        @Override
        public final Builder configurationValidationPolicy(DeploymentConfigurationValidationPolicy configurationValidationPolicy) {
            this.configurationValidationPolicy = configurationValidationPolicy;
            return this;
        }

        public final void setConfigurationValidationPolicy(DeploymentConfigurationValidationPolicy.BuilderImpl configurationValidationPolicy) {
            this.configurationValidationPolicy = configurationValidationPolicy != null ? configurationValidationPolicy.build() : null;
        }

        public DeploymentPolicies build() {
            return new DeploymentPolicies(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentPolicies> {
        public Builder failureHandlingPolicy(String var1);

        public Builder failureHandlingPolicy(DeploymentFailureHandlingPolicy var1);

        public Builder componentUpdatePolicy(DeploymentComponentUpdatePolicy var1);

        default public Builder componentUpdatePolicy(Consumer<DeploymentComponentUpdatePolicy.Builder> componentUpdatePolicy) {
            return this.componentUpdatePolicy((DeploymentComponentUpdatePolicy)((DeploymentComponentUpdatePolicy.Builder)DeploymentComponentUpdatePolicy.builder().applyMutation(componentUpdatePolicy)).build());
        }

        public Builder configurationValidationPolicy(DeploymentConfigurationValidationPolicy var1);

        default public Builder configurationValidationPolicy(Consumer<DeploymentConfigurationValidationPolicy.Builder> configurationValidationPolicy) {
            return this.configurationValidationPolicy((DeploymentConfigurationValidationPolicy)((DeploymentConfigurationValidationPolicy.Builder)DeploymentConfigurationValidationPolicy.builder().applyMutation(configurationValidationPolicy)).build());
        }
    }
}

