/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.LambdaEnvironmentVariablesCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaEventSource;
import software.amazon.awssdk.services.greengrassv2.model.LambdaEventSourceListCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaExecArgsListCopier;
import software.amazon.awssdk.services.greengrassv2.model.LambdaInputPayloadEncodingType;
import software.amazon.awssdk.services.greengrassv2.model.LambdaLinuxProcessParams;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaExecutionParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaExecutionParameters> {
    private static final SdkField<List<LambdaEventSource>> EVENT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventSources").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::eventSources)).setter(LambdaExecutionParameters.setter(Builder::eventSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LambdaEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_QUEUE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxQueueSize").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::maxQueueSize)).setter(LambdaExecutionParameters.setter(Builder::maxQueueSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxQueueSize").build()}).build();
    private static final SdkField<Integer> MAX_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxInstancesCount").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::maxInstancesCount)).setter(LambdaExecutionParameters.setter(Builder::maxInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxInstancesCount").build()}).build();
    private static final SdkField<Integer> MAX_IDLE_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxIdleTimeInSeconds").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::maxIdleTimeInSeconds)).setter(LambdaExecutionParameters.setter(Builder::maxIdleTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxIdleTimeInSeconds").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInSeconds").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::timeoutInSeconds)).setter(LambdaExecutionParameters.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()}).build();
    private static final SdkField<Integer> STATUS_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("statusTimeoutInSeconds").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::statusTimeoutInSeconds)).setter(LambdaExecutionParameters.setter(Builder::statusTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusTimeoutInSeconds").build()}).build();
    private static final SdkField<Boolean> PINNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("pinned").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::pinned)).setter(LambdaExecutionParameters.setter(Builder::pinned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pinned").build()}).build();
    private static final SdkField<String> INPUT_PAYLOAD_ENCODING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputPayloadEncodingType").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::inputPayloadEncodingTypeAsString)).setter(LambdaExecutionParameters.setter(Builder::inputPayloadEncodingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPayloadEncodingType").build()}).build();
    private static final SdkField<List<String>> EXEC_ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("execArgs").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::execArgs)).setter(LambdaExecutionParameters.setter(Builder::execArgs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execArgs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::environmentVariables)).setter(LambdaExecutionParameters.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<LambdaLinuxProcessParams> LINUX_PROCESS_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("linuxProcessParams").getter(LambdaExecutionParameters.getter(LambdaExecutionParameters::linuxProcessParams)).setter(LambdaExecutionParameters.setter(Builder::linuxProcessParams)).constructor(LambdaLinuxProcessParams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxProcessParams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCES_FIELD, MAX_QUEUE_SIZE_FIELD, MAX_INSTANCES_COUNT_FIELD, MAX_IDLE_TIME_IN_SECONDS_FIELD, TIMEOUT_IN_SECONDS_FIELD, STATUS_TIMEOUT_IN_SECONDS_FIELD, PINNED_FIELD, INPUT_PAYLOAD_ENCODING_TYPE_FIELD, EXEC_ARGS_FIELD, ENVIRONMENT_VARIABLES_FIELD, LINUX_PROCESS_PARAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<LambdaEventSource> eventSources;
    private final Integer maxQueueSize;
    private final Integer maxInstancesCount;
    private final Integer maxIdleTimeInSeconds;
    private final Integer timeoutInSeconds;
    private final Integer statusTimeoutInSeconds;
    private final Boolean pinned;
    private final String inputPayloadEncodingType;
    private final List<String> execArgs;
    private final Map<String, String> environmentVariables;
    private final LambdaLinuxProcessParams linuxProcessParams;

    private LambdaExecutionParameters(BuilderImpl builder) {
        this.eventSources = builder.eventSources;
        this.maxQueueSize = builder.maxQueueSize;
        this.maxInstancesCount = builder.maxInstancesCount;
        this.maxIdleTimeInSeconds = builder.maxIdleTimeInSeconds;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.statusTimeoutInSeconds = builder.statusTimeoutInSeconds;
        this.pinned = builder.pinned;
        this.inputPayloadEncodingType = builder.inputPayloadEncodingType;
        this.execArgs = builder.execArgs;
        this.environmentVariables = builder.environmentVariables;
        this.linuxProcessParams = builder.linuxProcessParams;
    }

    public final boolean hasEventSources() {
        return this.eventSources != null && !(this.eventSources instanceof SdkAutoConstructList);
    }

    public final List<LambdaEventSource> eventSources() {
        return this.eventSources;
    }

    public final Integer maxQueueSize() {
        return this.maxQueueSize;
    }

    public final Integer maxInstancesCount() {
        return this.maxInstancesCount;
    }

    public final Integer maxIdleTimeInSeconds() {
        return this.maxIdleTimeInSeconds;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final Integer statusTimeoutInSeconds() {
        return this.statusTimeoutInSeconds;
    }

    public final Boolean pinned() {
        return this.pinned;
    }

    public final LambdaInputPayloadEncodingType inputPayloadEncodingType() {
        return LambdaInputPayloadEncodingType.fromValue(this.inputPayloadEncodingType);
    }

    public final String inputPayloadEncodingTypeAsString() {
        return this.inputPayloadEncodingType;
    }

    public final boolean hasExecArgs() {
        return this.execArgs != null && !(this.execArgs instanceof SdkAutoConstructList);
    }

    public final List<String> execArgs() {
        return this.execArgs;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final LambdaLinuxProcessParams linuxProcessParams() {
        return this.linuxProcessParams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventSources() ? this.eventSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxQueueSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIdleTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinned());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPayloadEncodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecArgs() ? this.execArgs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxProcessParams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaExecutionParameters)) {
            return false;
        }
        LambdaExecutionParameters other = (LambdaExecutionParameters)obj;
        return this.hasEventSources() == other.hasEventSources() && Objects.equals(this.eventSources(), other.eventSources()) && Objects.equals(this.maxQueueSize(), other.maxQueueSize()) && Objects.equals(this.maxInstancesCount(), other.maxInstancesCount()) && Objects.equals(this.maxIdleTimeInSeconds(), other.maxIdleTimeInSeconds()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.statusTimeoutInSeconds(), other.statusTimeoutInSeconds()) && Objects.equals(this.pinned(), other.pinned()) && Objects.equals(this.inputPayloadEncodingTypeAsString(), other.inputPayloadEncodingTypeAsString()) && this.hasExecArgs() == other.hasExecArgs() && Objects.equals(this.execArgs(), other.execArgs()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.linuxProcessParams(), other.linuxProcessParams());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaExecutionParameters").add("EventSources", this.hasEventSources() ? this.eventSources() : null).add("MaxQueueSize", (Object)this.maxQueueSize()).add("MaxInstancesCount", (Object)this.maxInstancesCount()).add("MaxIdleTimeInSeconds", (Object)this.maxIdleTimeInSeconds()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("StatusTimeoutInSeconds", (Object)this.statusTimeoutInSeconds()).add("Pinned", (Object)this.pinned()).add("InputPayloadEncodingType", (Object)this.inputPayloadEncodingTypeAsString()).add("ExecArgs", this.hasExecArgs() ? this.execArgs() : null).add("EnvironmentVariables", this.hasEnvironmentVariables() ? this.environmentVariables() : null).add("LinuxProcessParams", (Object)this.linuxProcessParams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventSources": {
                return Optional.ofNullable(clazz.cast(this.eventSources()));
            }
            case "maxQueueSize": {
                return Optional.ofNullable(clazz.cast(this.maxQueueSize()));
            }
            case "maxInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.maxInstancesCount()));
            }
            case "maxIdleTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxIdleTimeInSeconds()));
            }
            case "timeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "statusTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.statusTimeoutInSeconds()));
            }
            case "pinned": {
                return Optional.ofNullable(clazz.cast(this.pinned()));
            }
            case "inputPayloadEncodingType": {
                return Optional.ofNullable(clazz.cast(this.inputPayloadEncodingTypeAsString()));
            }
            case "execArgs": {
                return Optional.ofNullable(clazz.cast(this.execArgs()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "linuxProcessParams": {
                return Optional.ofNullable(clazz.cast(this.linuxProcessParams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaExecutionParameters, T> g) {
        return obj -> g.apply((LambdaExecutionParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LambdaEventSource> eventSources = DefaultSdkAutoConstructList.getInstance();
        private Integer maxQueueSize;
        private Integer maxInstancesCount;
        private Integer maxIdleTimeInSeconds;
        private Integer timeoutInSeconds;
        private Integer statusTimeoutInSeconds;
        private Boolean pinned;
        private String inputPayloadEncodingType;
        private List<String> execArgs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private LambdaLinuxProcessParams linuxProcessParams;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaExecutionParameters model) {
            this.eventSources(model.eventSources);
            this.maxQueueSize(model.maxQueueSize);
            this.maxInstancesCount(model.maxInstancesCount);
            this.maxIdleTimeInSeconds(model.maxIdleTimeInSeconds);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.statusTimeoutInSeconds(model.statusTimeoutInSeconds);
            this.pinned(model.pinned);
            this.inputPayloadEncodingType(model.inputPayloadEncodingType);
            this.execArgs(model.execArgs);
            this.environmentVariables(model.environmentVariables);
            this.linuxProcessParams(model.linuxProcessParams);
        }

        public final Collection<LambdaEventSource.Builder> getEventSources() {
            if (this.eventSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventSources != null ? (Collection)this.eventSources.stream().map(LambdaEventSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSources(Collection<LambdaEventSource> eventSources) {
            this.eventSources = LambdaEventSourceListCopier.copy(eventSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSources(LambdaEventSource ... eventSources) {
            this.eventSources(Arrays.asList(eventSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSources(Consumer<LambdaEventSource.Builder> ... eventSources) {
            this.eventSources(Stream.of(eventSources).map(c -> (LambdaEventSource)((LambdaEventSource.Builder)LambdaEventSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSources(Collection<LambdaEventSource.BuilderImpl> eventSources) {
            this.eventSources = LambdaEventSourceListCopier.copyFromBuilder(eventSources);
        }

        public final Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        @Override
        public final Builder maxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public final void setMaxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public final Integer getMaxInstancesCount() {
            return this.maxInstancesCount;
        }

        @Override
        public final Builder maxInstancesCount(Integer maxInstancesCount) {
            this.maxInstancesCount = maxInstancesCount;
            return this;
        }

        public final void setMaxInstancesCount(Integer maxInstancesCount) {
            this.maxInstancesCount = maxInstancesCount;
        }

        public final Integer getMaxIdleTimeInSeconds() {
            return this.maxIdleTimeInSeconds;
        }

        @Override
        public final Builder maxIdleTimeInSeconds(Integer maxIdleTimeInSeconds) {
            this.maxIdleTimeInSeconds = maxIdleTimeInSeconds;
            return this;
        }

        public final void setMaxIdleTimeInSeconds(Integer maxIdleTimeInSeconds) {
            this.maxIdleTimeInSeconds = maxIdleTimeInSeconds;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        public final Integer getStatusTimeoutInSeconds() {
            return this.statusTimeoutInSeconds;
        }

        @Override
        public final Builder statusTimeoutInSeconds(Integer statusTimeoutInSeconds) {
            this.statusTimeoutInSeconds = statusTimeoutInSeconds;
            return this;
        }

        public final void setStatusTimeoutInSeconds(Integer statusTimeoutInSeconds) {
            this.statusTimeoutInSeconds = statusTimeoutInSeconds;
        }

        public final Boolean getPinned() {
            return this.pinned;
        }

        @Override
        public final Builder pinned(Boolean pinned) {
            this.pinned = pinned;
            return this;
        }

        public final void setPinned(Boolean pinned) {
            this.pinned = pinned;
        }

        public final String getInputPayloadEncodingType() {
            return this.inputPayloadEncodingType;
        }

        @Override
        public final Builder inputPayloadEncodingType(String inputPayloadEncodingType) {
            this.inputPayloadEncodingType = inputPayloadEncodingType;
            return this;
        }

        @Override
        public final Builder inputPayloadEncodingType(LambdaInputPayloadEncodingType inputPayloadEncodingType) {
            this.inputPayloadEncodingType(inputPayloadEncodingType == null ? null : inputPayloadEncodingType.toString());
            return this;
        }

        public final void setInputPayloadEncodingType(String inputPayloadEncodingType) {
            this.inputPayloadEncodingType = inputPayloadEncodingType;
        }

        public final Collection<String> getExecArgs() {
            if (this.execArgs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.execArgs;
        }

        @Override
        public final Builder execArgs(Collection<String> execArgs) {
            this.execArgs = LambdaExecArgsListCopier.copy(execArgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder execArgs(String ... execArgs) {
            this.execArgs(Arrays.asList(execArgs));
            return this;
        }

        public final void setExecArgs(Collection<String> execArgs) {
            this.execArgs = LambdaExecArgsListCopier.copy(execArgs);
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = LambdaEnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = LambdaEnvironmentVariablesCopier.copy(environmentVariables);
        }

        public final LambdaLinuxProcessParams.Builder getLinuxProcessParams() {
            return this.linuxProcessParams != null ? this.linuxProcessParams.toBuilder() : null;
        }

        @Override
        public final Builder linuxProcessParams(LambdaLinuxProcessParams linuxProcessParams) {
            this.linuxProcessParams = linuxProcessParams;
            return this;
        }

        public final void setLinuxProcessParams(LambdaLinuxProcessParams.BuilderImpl linuxProcessParams) {
            this.linuxProcessParams = linuxProcessParams != null ? linuxProcessParams.build() : null;
        }

        public LambdaExecutionParameters build() {
            return new LambdaExecutionParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaExecutionParameters> {
        public Builder eventSources(Collection<LambdaEventSource> var1);

        public Builder eventSources(LambdaEventSource ... var1);

        public Builder eventSources(Consumer<LambdaEventSource.Builder> ... var1);

        public Builder maxQueueSize(Integer var1);

        public Builder maxInstancesCount(Integer var1);

        public Builder maxIdleTimeInSeconds(Integer var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder statusTimeoutInSeconds(Integer var1);

        public Builder pinned(Boolean var1);

        public Builder inputPayloadEncodingType(String var1);

        public Builder inputPayloadEncodingType(LambdaInputPayloadEncodingType var1);

        public Builder execArgs(Collection<String> var1);

        public Builder execArgs(String ... var1);

        public Builder environmentVariables(Map<String, String> var1);

        public Builder linuxProcessParams(LambdaLinuxProcessParams var1);

        default public Builder linuxProcessParams(Consumer<LambdaLinuxProcessParams.Builder> linuxProcessParams) {
            return this.linuxProcessParams((LambdaLinuxProcessParams)((LambdaLinuxProcessParams.Builder)LambdaLinuxProcessParams.builder().applyMutation(linuxProcessParams)).build());
        }
    }
}

